clc       % clean the prompt.
clear all % clear the stored variables.
close all % close all the windows that could have been opened.


% space variables
N     = 401; 
x0    = 0  ;
x_end = 100;
dx    = (x_end-x0)/(N-1)    ; % with these values : dx = 0.25 (km)
x     =  [x0 : dx : x_end]' ;

% creating time variables
t      = 0  ;
t_end  = 500;
CFL    = 0.5;


%%% You can play with the following variables to see how sensitive to these
%%% parameters is the output of the model

% defining coefficients to solve the velocity equation
p = 0.2 ; % power of the gradient norm in the diffusion term
mu = 10*(x_end)^p ; % coef of the reaction term

q = 2 ; % power in the reaction term
B  = 1/(x_end)^q; % coef of the reaction term 

rho = 100/x_end;

% initial data
amp_H = 0.01*(x_end-x0);
amp_v = 0.01*(x_end-x0);

%setting up the bed topology
bed = amp_H*( 2 -x/x_end                                 ... main slope
      +0.3 *cos(8*pi*x/x_end).*(x/x_end-1).^2.*x/x_end   ... main oscillations
      +0.05 * cos(64*pi*x/x_end).*(x/x_end-1).^2.*x/x_end );% small oscillations

%initial ice thickness
H = amp_H*(1-0.5*x/x_end                                  ... main slope
  + 2*exp(-(x/x_end-0.5).^2 *20).*(1-x/x_end).*(x/x_end));%   bump of ice
% initial velocity 
U = amp_v*ones(size(H));

% Dirichlet BC values
H_dirichlet = amp_H  ;
u_dirichlet = amp_v;
% snow accumulation rate
M = 0.0 * ( 1 -x); ... set to zeros for simplicity
    

% for plotting 
it = 0;
y_max = max(max(abs(U)),max(bed+H))*1.3;

while t < t_end
   %updating velocities -> solving the non-linear system
   [f,H]           = build_source_term(H,bed,rho,dx);
    mu_H           = mu*H;     % different viscosity (compared with the non-linear equation exercise)
   [U,it_nl,delta] = NL_get_velocity_picard(U,mu_H,B,f,p,q,x,dx,u_dirichlet);

   %setting dt depending on velocity fluctuations
   dt = transport_get_dt(CFL,U,dx);  

   % obtaining the new ice thickness, transported by the velocity.
   H = solve_transport_time_step(H,U,dx,dt,M,H_dirichlet);

   % just for plotting and displaying some data
   % if one writes mod(it,1) == 0 it will be at every iteration
   if mod(it,50) == 0
     y_max=  plot_nicely(t,dt,x,bed,H,U,y_max,it_nl,delta);
   end
   
   %advancing in time
   t=t+dt;
   it = it +1;   
   
end


