function V = Newton(U,tol_N,it_max,D_x1,D_y1,D_x2,D_y2,Id,D_H,D_Z,v_x,v_y,...
                    alpha,beta,dt,div,N)

% Compute M2(U)
[M2] = DiscreteRHS(Id,D_x1,D_y1,D_x2,D_y2,D_H,D_Z,v_x,v_y,alpha,beta,...
                   dt,div,U,N);

    
% Solve F(V) = M1(V)*V - M2(U)*U = 0 by Newton method
V = U;              % initial guess
delta_V = Inf;      % Rate of change of V (to enter the loop)
it = 0;             % Iteration counter

while norm(delta_V)>tol_N && it<it_max
    
    % Compute M1(V)
    [M1] = DiscreteLHS(Id,D_x1,D_y1,D_x2,D_y2,D_H,D_Z,v_x,v_y,alpha,beta,dt,...
                          div,V,N);

    % Compute F(V) and Jac(V)
    F   = M1*V - M2*U ;
    Jac = ComputeJac(Id,D_x1,D_y1,D_x2,D_y2,D_H,D_Z,v_x,v_y,...
                            alpha,beta,dt,div,V,N) ;
    
    % Improve the estimate of V
    delta_V = Jac\F ;
    V = V-delta_V;
    it = it+1;
    
    % Print progress
    if mod(it,1000)==0
        fprintf('it = %d, delta = %f \n',it,norm(delta_V));
    end
    
end

% Check negative numbers
if min(V)<0
    disp('Negative values! Decrease the time step!');
end

% Convergence message
if it<it_max
    fprintf('Converged after %d iterations \n',it);
else
    fprintf('Not converged! delta = %f \n',norm(delta_V));
end

end