function [D_x1,D_y1,D_x2,D_y2] = ApplyBC(D_x1,D_y1,D_x2,D_y2,x,y,dx,dy,I,N,L_x,L_y)

% Indices of boundary nodes
left   = find(x(:)==0  ); 
right  = find(x(:)==L_x);    
bottom = find(y(:)==0  );    
top    = find(y(:)==L_y);        

% Discretization matrices for boundaries (ghost point method)
e = ones(N,1);
D_x2l = spdiags( [-2*e  2*e]/dx^2 , [0      I  ] , I , N );
D_x2r = spdiags( [ 2*e -2*e]/dx^2 , [N-2*I  N-I] , I , N );
D_y2b = spdiags( [-2*e  2*e]/dy^2 , [0     -1  ] , N , N );
D_y2t = spdiags( [ 2*e -2*e]/dy^2 , [1      0  ] , N , N );

% Replace global discretization matrices on boundaries
D_x2(left        ,:) = D_x2l;
D_x2(right       ,:) = D_x2r;
D_y2(bottom      ,:) = D_y2b(bottom,:);
D_y2(top         ,:) = D_y2t(top   ,:);
D_x1([left;right],:) = 0;
D_y1([bottom;top],:) = 0;

end