\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{tubrief}[2010/09/02 LaTeX2e class]
% declare tubrief-specific options
\DeclareOption{bluelogo}{\bluelogo}
\DeclareOption{blacklogo}{\blacklogo}
\DeclareOption{persistentrefline}{\def\@persistentrefline{\true}}
% pass all other options to dinbrief.cls
\DeclareOption*{\PassOptionsToClass{\CurrentOption}{dinbrief}}
%\DeclareOption*{\PassOptionsToPackage{\CurrentOption}{graphicx}}

% code influenced by class options (must be placed before invoking \ProcessOptions)
%  make placeholders for logo filename
\newcommand\@tulogo{logos/TU_Logo}
\newcommand\@tusignet{logos/TU_Signet_CMYK}
\newcommand\bluelogo{\renewcommand\@tulogo{logos/TU_Logo}%
		   \renewcommand\@tusignet{logos/TU_Signet_CMYK}}
\newcommand\blacklogo{\renewcommand\@tulogo{logos/TU_Logo_black}%
		   \renewcommand\@tusignet{logos/TU_Signet_SW_rgb}}
%  refline persistence
\def\@persistentrefline{}

% process options
\ProcessOptions
% load the dinbrief base class
\LoadClass{dinbrief}
% graphics is needed to include the tu logo
\RequirePackage{graphicx}
% use the local settings for austria
\RequirePackage[naustrian]{babel}


% set lengths, widths, margins etc. according to M$-Word template
\setlength{\hoffset}{-1in}%
\addtolength{\hoffset}{2.5cm}%
\setlength{\oddsidemargin}{0pt}%
\setlength{\textwidth}{16.5cm}%
\setlength{\parindent}{0pt}

% define horizontal partioning lengths - we'll use these a lot
\newlength\onethird
\newlength\twothird
\onethird5.5cm
\twothird11cm

% define non-scaling fontsizes for refline and footnotes indepenently of the document fontsize
\newcommand{\tusmall}{\fontsize{9}{11}\selectfont}
\newcommand{\tutiny}{\fontsize{8}{10}\selectfont}
% use sans serif as default
\renewcommand{\familydefault}{\sfdefault}

% use 1976 standard and disable standard switching, otherwise it will get in our way
\disabledraftstandard
\renewcommand\enabledraftstandard{}
\renewcommand\disabledraftstandard{}

% commands to make reference line always enabled regardless of its content
\let\@reflinefalsebackup\@reflinefalse
\newcommand\persistentrefline{%
   \@reflinetrue%
   \renewcommand\@reflinefalse{}}
\newcommand\nopersistentrefline{%
   \renewcommand\@reflinefalse{\@reflinefalsebackup}%
   \@reflinefalse}
% check 'persistentrefline' class option
\ifx\@persistentrefline\@empty\relax%
\else\persistentrefline\fi

% hack of original dinbrief code to align date to adress field
\def\ka@db@tsrefline{% 
  \if@norefline\else 
    \vbox{% 
      \if@refline 
        \@answerto 
      \else 
        \if@letterform\relax\else 
          \ifx\@empty\@place 
            \hskip\twothird \@date % hacked
          \else 
            \hskip\twothird \@place,\space\@date % hacked as well
          \fi 
        \fi 
      \fi 
    }% 
    \nointerlineskip 
    \par 
    \bigskip 
  \fi %\if@norefline 
}

% make our own reference line
\renewcommand{\@answerto}%
{%
   % put the reference line
   \noindent%
   \parbox[t]{\onethird}{\raggedright{\tutiny\sffamily\yourmailmsg}\\\@yourmail}%
   \parbox[t]{\onethird}{\raggedright{\tutiny\sffamily\signmsg}\\\@mymail}%
   \parbox[t]{\onethird}{\raggedright{\tutiny\sffamily\writermsg}\\%
      {\ka@db@usevar{writer}}}%
   % put the date
   \hskip-\onethird\parbox[t]{\onethird}{\vspace{1cm}%
      \ifx\@empty\@place \relax \else \@place,\space \fi \@date}%
}

% add some new commands for specifying information about the sender
\newcommand\@institutelogo{}
\newcommand\@instituteaddress{}
\def\@billingaddress{}
\newcommand\@sender{}
\newcommand\@contact{}
\newcommand\institutelogo[1]{\renewcommand\@institutelogo{#1}}
\newcommand\instituteaddress[1]{\renewcommand\@instituteaddress{#1}}
\newcommand\billingaddress[1]{\def\@billingaddress{#1}}
\newcommand\sender[1]{\renewcommand\@sender{#1}}
\newcommand\contact[1]{\renewcommand\@contact{#1}}

% user \parskip as space between sections of the address field 
\newlength\addressskip
\addressskip\parskip

% define our custom address field
\address%
{%
   \vskip1.5mm%
   % put the TU logo on the left
   \parbox[b]{0.42\textwidth}{\includegraphics[height=2cm]{\@tulogo}}%
   \hfill%
   % put the institute's logo on the right
   \parbox[b]{\onethird}{\raggedright\@institutelogo}%
   \\[\addressskip] %
   \hspace{\twothird}%
   % generate a column on the right containing sender information
   \parbox[t]{\onethird}%
   {%
   	\raggedright\tusmall%
      {\@instituteaddress\\[\addressskip]}%
      % if there's no billing address given we don't need to put 'Rechnungsaddresse:'
      \ifx\@billingaddress\@empty
      \relax 
      \else Rechnungsadresse:\\ %
      {\@billingaddress\\[\addressskip]} \fi%
      {\@sender\\[\addressskip]}%
      {\@contact}%
   }%
}

% prevent user from changing the layout of the address field
\renewcommand{\address}[1]{%
   \ClassWarning{tubrief}{%
      \protect\address macro\space disabled in tubrief; please use the macros \protect%
      \instituteaddress, \protect\billingaddress, \protect\sender, and %
      \protect\contact\space instead.\MessageBreak}}

% \@plainconcern contains the unformatted subject, 
% whereas \@concern holds the formatted one
\newcommand\@plainconcern{}

% contains legal information to be put in the right corner of first page's footline
\newcommand\@legalbox{}
% command for setting above variable
\newcommand\legalbox[1]{\renewcommand\@legalbox{#1}}

% define custom format for the first page's footline [pagenum <-----> legalbox]
\bottomtext{%
   \hbox to \textwidth {%{\tutiny{}Seite \thepage/\pageref{LastPage:\theletter}}\hfill%
   %\begin{tabular}[t]{@{\tutiny}l@{}}\@legalbox\end{tabular}}%
    \parbox[t]{\twothird}{\tutiny{}Seite \thepage/\pageref{LastPage:\theletter}}\nobreak
    \parbox[t]{\twothird}{\tutiny{}\@legalbox}\hss}
}

% prevent user from changing the footline layout on the first page
\renewcommand\bottomtext{%
   \ClassWarning{tubrief}{%
      \protect\bottomtext\space macro disabled in tubrief; please use the macro \protect%
      \legalbox\space instead.\MessageBreak}}

% define the pagestyle for the pages 2, 3, ...   
\newcommand{\ps@tubrief}%
{%
	% define footline [subject <------> pagenum <-----> date]
	% pagenum is centered with respect to text body
   \renewcommand{\@oddfoot}{%
      \parbox[t]{\textwidth}{\raggedright\tutiny\@plainconcern}%
      \hskip-\textwidth%
      \parbox[t]{\textwidth}{%
         \centering\tutiny\pagename\thepage/\pageref{LastPage:\theletter}}%
      \hskip-\textwidth%
      \parbox[t]{\textwidth}{\raggedleft\tutiny\@date}}%
   \let\@evenfoot\@oddfoot%
   % put small logo (=signet) at the appropriate place in the headline
   \renewcommand{\@oddhead}{\vbox to 0pt{\vskip -1.1cm\raggedright%
      \includegraphics[height=1.2cm]{\@tusignet}\vss}}%
   \let\@evenhead\@oddhead%
   % enlarge space between headline and text body and adjust text height accordingly
   \addtolength{\textheight}{\headsep}%
   \addtolength{\headsep}{1cm}%
   \addtolength{\textheight}{-\headsep}%
}

% use our newly defined pagestyle
\pagestyle{tubrief}

% when compiler hits \end{letter} dump the number of pages of to the aux file
% this is needed in the footline definitions to produce 'page n of m' (Seite n/m)
\renewcommand\stopletter{%
   \immediate\write\@auxout{\string%
   \newlabel{LastPage:\theletter}{{}{\thepage}}}}

% copied from dinbrief.sty and modified to make the subject bold 
% and store the unformatted subject line in \@plainconcern
\renewcommand\concern[1]{% 
   \setbox\@betr=\hbox{} %
   \renewcommand\@plainconcern{#1} %
   \def\@concern{\hangindent=\wd\@betr %
   \hangafter=1 %
   \unhbox\@betr{\bfseries #1}\par}} 
\let\subject=\concern


% center the address vertically inside the address window
\centeraddress
% disable rules above and below address window
\nowindowrules


% this is executed at \begin{document} to prevent interference with babel
\AtBeginDocument{
% custom strings for reference line
\renewcommand\yourmailmsg{Ihr Zeichen}
\renewcommand\signmsg{Unser Zeichen}
\renewcommand\writermsg{Sachbearbeitung}

% custom strings for CC and encl
\renewcommand\ccname{\underline{ergeht in Kopie an:}}
\renewcommand\enclname{\underline{Anlagen:}}

% Format \today as 02.09.2010 not 02. September 2010
\renewcommand\ntoday{\@znumber{\number\day}.%
            \@znumber{\number\month}.%
            {\number\year}}
\let\today\ntoday
}

\endinput
