      include "inout.f"
      include "tpiece.f"

      program main
      
      implicit real*8 (a-h,o-z)  
      parameter (NXX=2000)
      dimension uold_z1(2,0:NXX),unew_z1(2,0:NXX), Aeff_z1(0:nxx)
c      dimension uold_z2(2,0:NXX),unew_z2(2,0:NXX), Aeff_z2(0:nxx)
      dimension uold_l(2,0:NXX),unew_l(2,0:NXX), Aeff_l(0:nxx)     
      dimension xold2(4),xold(4),xnew(4),rmdot(4),Avalve(4),istatev(4)
      dimension vvalve(4)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca
      common /probe/ vfc
      common /sensor/ se_d1, se_d2, se_d3
      common /periodic/ rmgesamt, vmax, work, workloss
      
      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin


c schaun obs passt
c      Open (97,File='.\\solver\\STOP', STATUS='OLD')
c      read (97,*) hlp
c      if (hlp.ne.4321) STOP
c      close(97)
c Definition der Konstanten, Parameter    
      call setparam
      
c doubleacting cylinder = 1
      idouble = 0
c null setzen der periodischen groesen

      rmgesamt=0.0d0
      vmax=0.0d0
      work=0.0d0
      workloss=0.0d0
C___________________________________________________________
 
C Diskretisierungsparameter
      ITT=0
C -AÃ¯Â¿Â½berschriften Ã¯Â¿Â½ber Protokollfiles-b
      Open (96,File='statistic.dat')
      Open (98,File='periode.dat')
      rmgesamt=0.0
      open (90,File='output.dat')
      write (90,'(17A20)') ' Time ', ' Crank_Angle ',
     *  ' Mass_inside_Cylinder ',' Volume_inside_Cylinder ',
     *  ' Average_pressure ',' Pressure_suct ',' Pressure_disch ',
     *  ' Pressure_cent ',' Pressure_ret ',' Massflow_suct ',
     *  ' Massflow_disch ',' Valve_lift_suct ','Valve_lift_disch ',
     *  ' VP_velocity_suct ',' VP_velocity_disch ',
     *  ' Moment_onto_Piston',' Temp_cent'



C bestimmung des Anfangszustandes Uold_z1,
       
      call anfang(uold_z1,uold_l,aeff_z1,aeff_l,vvalve,
     *     xold,xold2,avalve,istatev,rmdot,rmdoto,t,startphi)
      call statistic(t,aeff_z1)
      call ausgabe1 (ITT,T,Uold_z1,Uold_z2,Uold_l,aeff_z1,aeff_z2,
     *     aeff_l,xold,xold2,xnew,vvalve,avalve,istatev,rmdot)





C Jeder Nprint-te Zeitschritt wird ausgegeben
c      Nprint=100
      ip =0
      iper=1
      do 100 i=1,1000000
          T = T+dt
          ITT = ITT+1 
          call timestep (uold_z1,uold_z2,uold_l,aeff_z1,aeff_z2,aeff_l,
     *     xold,xold2,xnew,vvalve,avalve,istatev,rmdot,rmdoto,t,
     *     unew_z1,unew_z2,unew_l,idouble)
          call hoehe(t,h,dhdt,phi)
c          call ausgabe1 (itt,t,unew_z1)   
          if ((phi*180/3.1415).gt.(startphi+ip*repca+0.)) then
             ip=ip+1
c             Open (97,File='.\\solver\\STOP', STATUS='OLD')
c             read (97,*) hlp
c             if (hlp.eq.1) STOP
             write (*,'(f10.2)') phi*180/3.1415
c             call flush (6)
c             close (97)
c             write (*,*) phi*180/3.1415
             call ausgabe1 (itt,t,unew_z1,unew_z2,unew_l,
     *            aeff_z1,aeff_z2,aeff_l,xold,xold2,xnew,vvalve,
     *            avalve,istatev,rmdot) 
c             write (*,*) 'darum'
          endif
          if ((phi*180/3.1415).gt.(360.*iper-180.)) then
             call periode
             iper=iper+1
             rmgesamt=0.0d0
             vmax=0.0d0
             work=0.0d0
             workloss=0.0d0
          endif
          if ((phi*180/3.1415).gt.endca) stop
 100   continue
 101   continue 
      close (90) 
      close (70)
      end 
c-----------------------------------------------------------------------

      subroutine anfang(uold_z1,uold_l,aeff_z1,aeff_l,
     *     vvalve,xold,xold2,avalve,istatev,rmdot,rmdoto,t,startphi)
      implicit real*8(A-H,O-Z)
      parameter (NXX=2000)
      dimension uold_z1(2,0:NXX),unew_z1(2,0:NXX), Aeff_z1(0:nxx)
c      dimension uold_z2(2,0:NXX),unew_z2(2,0:NXX), Aeff_z2(0:nxx)
      dimension uold_l(2,0:NXX),unew_l(2,0:NXX), Aeff_l(0:nxx)     
      dimension xold2(4),xold(4),xnew(4),rmdot(4),Avalve(4),istatev(4)
      dimension vvalve(4)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin
      



c initial conditions and boundary conditions of gas
      rhoindim =   pindim/tindim/R
    
c initial conditions of the valves
      rmdoto = 0.0d0
      do 10 i=1,4
         xold2(i)   = 0.0d0
         xold(i)    = 0.0d0
         rmdot(i)    = 0.0d0
         Avalve(i)  = 0.0d0
         istatev(i) = 0
         vvalve(i)  = 0.0d0
 10   continue
      

c initial height and inital temperature
      hinit = h0+2.0d0*rkr
      tinit = tindim

      
c Definition der Bezugsgroesen
      PI     = 3.141592653589793238 
      Aref   = h0*D
      omega  = rn * PI / 30
      tref   = sqrt(h0/(rkr*omega**2*(1+rkr/pl)))

c Anfangszeit aus der Anfangshoehe berechnen.

      h=hinit/h0
      t=-5
      DO 20 i=1,60
         call hoehe(t,h,dhdt,phi)
         t=t-(h-hinit/h0)/dhdt
 20   continue

c Bestimmung des Anfangswinkels

      do 30 i=-180,180
         if (i.gt.(phi*180/PI)) then
            startphi=i
            goto 31
        endif
 30   continue
 31   continue


c bestimmung der Flaechen
      call initarea(t,Aeff_z1,Aeff_l)

c die referenzgroese fuer Aref=h0*D

c      write (*,*) dhdt,h
      rhoinit= pindim/tindim/R
      rmref  = rhoinit*Aref 
      riref  = D/tref
      pref   = pindim
      rhoin  = rhoinit
c bestimmung von epsilon
      epsilon = pindim/rhoinit*rkappa/(rkappa-1)*tref**2/d**2      
c randbendingungen dimensionslos
      pout = poutdim / pref
      pin  = pindim / pref
c anfangsdichte in laterne+druckleitung
      rhomax=(poutdim/pindim)**(1/rkappa)*rhoinit
C Anfangszustand 

      do 40 i=0,NXz+1
         uold_z1(1,i) = rhoinit*Aeff_z1(i)*Aref/rmref 

         uold_z1(2,i) = 0.d0   

 40   continue
      
      do 50 i=nxz+2,nx+3
         uold_z1(1,i) = rhomax*Aeff_z1(i)*Aref/rmref 

         uold_z1(2,i) = 0.d0   

 50   continue

      do 60 i=0,nxl+1
         uold_l(1,i) = rhomax*Aeff_l(i)*Aref/rmref 
         uold_l(2,i) = 0.d0   
 60   continue
      return
      end
c ---------------------------------------------------------------------------

      subroutine hoehe(t,h,dhdt,phi)
      implicit real*8(A-H,O-Z)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin


      PI=3.141592653589793238
      tdim=t*tref      
      rlambda= rkr/pl
      phi    = rn * PI / 30 * tdim
      dphidt = rn * PI / 30
      hdim   = rkr * (1 - cos(phi)) + h0 + pl *(1- sqrt(1- rlambda **2 * 
     *         sin(phi)**2));
      dhdtdim= rkr * sin(phi)*dphidt + pl*rlambda**2*sin(2*phi)/
     *         (2 * sqrt((1-rlambda**2*sin(phi)**2)))*dphidt;
      h=hdim/h0
      dhdt=dhdtdim*tref/h0
      
      return
      end 
c ----------------------------------------------------------------------      
      
      subroutine flaeche(t,Aeff_z1,Aeff_l)
      implicit real*8(A-H,O-Z)
      parameter (NXX=2000)
      dimension aeff_z1(0:nxx),aeff_l(0:nxx)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin

      PI=3.141592653589793238


c definition lengths and areas
      
      rlventg1 = vp_l3
      rlventk  = vp_l2
      rlventg2 = vp_l1
      rlvent   = rlventg1+rlventk+rlventg2
      aventk2  = vp_a1
      
      
c calculate current height
      call hoehe(t,h,dhdt,phi)      
      h2=(2*rkr+2*h0)/h0-h      
      bmin=vp_ws
      if (rnvalve.eq.2) bmin=0.7*D/2.0d0

      amin1=bmin*h*h0
      amin2=bmin*h2*h0
      if (amin1.gt.aventk2) amin1=aventk2
      if (amin2.gt.aventk2) amin2=aventk2

   

c cylinder
      do 45 i=nxd1+1, nxz-nxd1
         xdim=(i-1)*dx*d
         bdim=2*sqrt((d/2)**2-(d/2+rlvent-xdim)**2)
         Aeff_z1(i)=h*bdim/D/rnvalve

         if (Aeff_z1(i).lt.Amin1/Aref) Aeff_z1(i)=Amin1/Aref

 45   continue 
      
      if (ncp.eq.1) then
         do 46 i=nxd1+1, nxd2
            xdim=(i-1)*dx*d
            bdim=2*sqrt((d/2)**2-(d/2+rlvent-xdim)**2)
            Aeff_z1(i)=h*bdim/D+cp_A/Aref

 46      continue
      
         do 47 i=nxz-nxd2, nxz-nxd1
            xdim=(i-1)*dx*d
            bdim=2*sqrt((d/2)**2-(d/2+rlvent-xdim)**2)
            Aeff_z1(i)=h*bdim/D+cp_A/Aref

 47      continue
      endif
      return
      end

      
C___________________________________________________________________________
      
      subroutine timestep(uold_z1,uold_z2,uold_l,aeff_z1,aeff_z2,aeff_l,
     *     xold,xold2,xnew,vvalve,avalve,istatev,rmdot,rmdoto,t,
     *     unew_z1,unew_z2,unew_l,idouble)
      implicit real*8(a-h,o-z)
      parameter (NXX=2000)
      dimension uold_z1(2,0:NXX),unew_z1(2,0:NXX), Aeff_z1(0:nxx)
      dimension uold_l(2,0:NXX),unew_l(2,0:NXX), Aeff_l(0:nxx)     
      dimension xold2(4),xold(4),xnew(4),rmdot(4),Avalve(4),istatev(4)
      dimension urv(6),uold1(2),uold2(2),uold3(2),ul1(2),ul2(2),ur3(2)
      dimension ul(2),ur(2),ull(2),um(2)
      dimension ubnew(2),ubold(2),zplus(2),zminus(2)
      dimension F(3),DF(3,3),ulambda(3),e1(3),e2(3)
      dimension vvalve(4)
      dimension aeff(0:NXX), o(0:nxx), o1(0:nxx)

      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca
      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin
      common /periodic/ rmgesamt, vmax, work, workloss




c umspeichern
       
      do 10 i=0,NX+3
         do 10 j=1,2
            unew_z1(j,i)=uold_z1(j,i)

 10   continue
      
      do 20 i=0,NXl+1
         do 20 j=1,2
            unew_l(j,i)=uold_l(j,i)         
 20   continue





c Bestimmung der cross-section
c und ventil bestimmen

      call hoehe(t,h,dhdt,phi)    
      call flaeche(t,Aeff_z1,Aeff_l)
      call calcvalves(uold_z1,uold_l,aeff_z1,aeff_l,
     *     xold,xold2,xnew,vvalve,avalve,istatev,rmdot)

c      if (2.*Aeff_z1(nxz-nxd2-2).lt.Aeff_z1(nxz-nxd2+1)) then
c         if (istatev(2).eq.1) then
c          Al=Aeff_z1(nxz-nxd2-3)
c          ul(1)=uold_z1(1,nxz-nxd2-3)
c          ul(2)=uold_z1(2,nxz-nxd2-3)
c          Ar=Aeff_z1(nxz-nxd2+2)
c          ur(1)=uold_z1(1,nxz-nxd2+2)
c          ur(2)=uold_z1(2,nxz-nxd2+2)
c          As=Aeff_z1(nxz-nxd2-2)
c          call druckverl(ul,ur,Al,Ar,As,rmdotb)
c          endif
c       endif

c new condition for first cylinder

       do 30 i=1,nx+3
          s=0.0d0
          do 31 j=1,2
             ul(j)=uold_z1(j,i-1)
             ur(j)=uold_z1(j,i)
 31       continue
          Al=Aeff_z1(i-1)
          Ar=Aeff_z1(i)
          call fwaves(ul,ur,al,ar,s,zplus,zminus)
          do 32 j=1,2
             unew_z1(j,i)=unew_z1(j,i)-dt/dx*zplus(j)
             unew_z1(j,i-1)=unew_z1(j,i-1)-dt/dx*zminus(j)
 32       continue
 30    continue

c maccormack



c      call mcc(t,uold_z1,unew_z1,Aeff_z1,rmdot)
c       call laxw(t,uold_z1,unew_z1,Aeff_z1,rmdot)



      if (nvr.eq.3) then
c new condition for rest of laterne

       do 50 i=1,nxl+1
          s=0.0d0
          do 51 j=1,2
             ul(j)=uold_l(j,i-1)
             ur(j)=uold_l(j,i)
 51       continue 
          Al=Aeff_l(i-1)
          Ar=Aeff_l(i)
          call fwaves(ul,ur,al,ar,s,zplus,zminus)
          do 52 j=1,2
             unew_l(j,i)=unew_l(j,i)-dt/dx*zplus(j)
             unew_l(j,i-1)=unew_l(j,i-1)-dt/dx*zminus(j)
 52       continue
 50    continue
      



c tstueck rechnen

       do 60 j=1,2
          uold1(j)=uold_z1(j,nxt)
          uold2(j)=uold_z1(j,nxt+1)
          uold3(j)=uold_l(j,0)
          ul1(j)=uold_z1(j,nxt-1)
          ul2(j)=uold_z1(j,nxt+2)
          ur3(j)=uold_l(j,1)
 60    continue
       a1=aeff_z1(nxt)
       a2=aeff_z1(nxt+1)
       a3=aeff_l(0)
       al1=a1
       al2=a2
       ar3=a3

c       call verzweigung (uold1,uold2,uold3,ul1,ul2,ur3,
c     *        a1,a2,a3,al1,al2,ar3,urv,t)
      ihilfe=1
c      write (*,'(I1,6G26.16)')ihilfe,uold1(1),uold2(1),uold3(1),
c     *     ul1(1),ul2(1),ur3(1)
        call root (uold1,uold2,uold3,ul1,ul2,ur3,
     *        a1,a2,a3,al1,al2,ar3,urv,t)

c       unew_z1(1,nxt)=urv(3)
c       unew_z1(2,nxt)=urv(1)
c       unew_z1(2,nxt+1)=urv(2)
c       unew_z1(1,nxt+1)=unew_z1(1,nxt)*A2/A1
c       unew_l(1,0)=unew_z1(1,nxt)*A3/A1
c       unew_l(2,0)=(unew_z1(1,nxt)*unew_z1(2,nxt)-
c     *      unew_z1(1,nxt+1)*unew_z1(2,nxt+1))/unew_l(1,0)
c      ihilfe=2
c       write (*,'(I1,4G26.16)') ihilfe,urv(1),urv(3),urv(5),urv(2)
       unew_z1(1,nxt)=urv(1)
       unew_z1(2,nxt)=urv(2)
       unew_z1(2,nxt+1)=urv(4)
       unew_z1(1,nxt+1)=urv(3)
       unew_l(1,0)=urv(5)
       unew_l(2,0)=urv(6)
       
c ausstroemen mit gegendruck in den druckbehaelter


c       do 65 j=1,2
c          ul(j) = uold_l(j,nxl)
c          ubold(j) = uold_l(j,nxl+1)
c 65    continue
c       al=aeff_l(nxl)
c       ab=aeff_l(nxl+1)
c       call Ausstroem1 (ul,ubold,al,ab,pout,ubnew)
c       do 66 j=1,2
c          unew_l(j,nxl+1)=ubnew(j)
c 66    continue


        Al=Aeff_l(nxl)
        ul(1)=uold_l(1,nxl)
        ul(2)=uold_l(2,nxl)
        call ausstroem2 (ul,Al,rmdota)
c        write (*,*) rmdota
        unew_l(1,nxl)=
     *       unew_l(1,nxl)-rmdota*dt/dx

        unew_l(1,nxl+1)=unew_l(1,nxl)
        unew_l(2,nxl+1)=-unew_l(2,nxl)


c ende der laterne
       unew_z1(1,nx+3)= unew_z1(1,nx+2)
       unew_z1(2,nx+3)=-unew_z1(2,nx+2)

      endif

c boundary condition suction valve-reflection
       
       
      UNEW_z1(1,1) = UNEW_z1(1,1) + rmdot(1)*DT/DX
      
      unew_z1(1,0)= unew_z1(1,1)
      unew_z1(2,0)=-unew_z1(2,1)
      
C Ausstroemrandbedingung bei nxz, ventil

                       
      UNEW_z1(1,NXz)= unew_z1(1,NXz)- rmdot(2)*DT/DX

      unew_z1(1,nxz+1)= unew_z1(1,nxz)
      unew_z1(2,nxz+1)=-unew_z1(2,nxz)

    


c boundary conditions for valve cage


      UNEW_z1(1,NXz+3)= UNEW_z1(1,NXz+3)+ rmdot(2)*DT/DX
       
      unew_z1(1,nxz+2)= unew_z1(1,nxz+3)
      unew_z1(2,nxz+2)=-unew_z1(2,nxz+3)



c ausstroemen aus retainer
      if (nvr.lt.3) then
         stau=uold_z1(1,nx+2)/Aeff_z1(nx+2)*uold_z1(2,nx+2)**2/2.0d0
         unew_z1(2,nx+2)=2.*unew_z1(2,nx+1)-unew_z1(2,nx)
         if (uold_z1(2,nx+2).gt.0) then
          unew_z1(1,nx+2)=Aeff_z1(nx+2)*((pout+stau*2.0d0)/
     *        1.)**(1/rkappa)
         else
          unew_z1(1,nx+2)=Aeff_z1(nx+2)*((pout-stau*1.5d0)/
     *         1.)**(1/rkappa)
         endif
      endif




c druckverlust wenn bedingung erfuellt

       if (2.*Aeff_z1(nxz-nxd2-2).lt.Aeff_z1(nxz-nxd2+1)) then  
          if (istatev(2).eq.1) then       

             UNEW_z1(1,NXz-nxd2+1)=UNEW_z1(1,NXz-nxd2-1)*
     *            Aeff_z1(NXz-nxd2+1)/Aeff_z1(NXz-nxd2-1)
             UNEW_z1(2,NXz-nxd2+1)=UNEW_z1(2,NXz-nxd2-1)*
     *            Aeff_z1(NXz-nxd2-1)/Aeff_z1(NXz-nxd2+1)
             UNEW_z1(1,NXz-nxd2)=UNEW_z1(1,NXz-nxd2+2)*
     *            Aeff_z1(NXz-nxd2)/Aeff_z1(NXz-nxd2+2)
             UNEW_z1(2,NXz-nxd2)=UNEW_z1(2,NXz-nxd2+2)*
     *            Aeff_z1(NXz-nxd2+2)/Aeff_z1(NXz-nxd2)

          endif
       endif
       
c druckverlust wenn bedingung erfuellt

       if (2.*Aeff_z1(nxz-nxd1-2).lt.Aeff_z1(nxz-nxd1+1)) then
c          if (istatev(2).eq.1) then
c
             UNEW_z1(1,NXz-nxd1+1)=UNEW_z1(1,NXz-nxd1-1)*
     *            Aeff_z1(NXz-nxd1+1)/Aeff_z1(NXz-nxd1-1)
             UNEW_z1(2,NXz-nxd1+1)=UNEW_z1(2,NXz-nxd1-1)*
     *            Aeff_z1(NXz-nxd1-1)/Aeff_z1(NXz-nxd1+1)
             UNEW_z1(1,NXz-nxd1)=UNEW_z1(1,NXz-nxd1+2)*
     *            Aeff_z1(NXz-nxd1)/Aeff_z1(NXz-nxd1+2)
             UNEW_z1(2,NXz-nxd1)=UNEW_z1(2,NXz-nxd1+2)*
     *            Aeff_z1(NXz-nxd1+2)/Aeff_z1(NXz-nxd1)

c          endif
       endif

C Berechnen der periodischen GrÃ¯Â¿Â½Ã¯Â¿Â½Ã¯Â¿Â½en

      if (vvalve(2).gt.vmax) vmax=vvalve(2)
      rmgesamt=rmgesamt+rmdot(2)*dt
      call flaeche(t-dt,aeff,o)
      do 315 i=nxd1+1,nxz-nxd1
             rho = unew_z1(1,i)/Aeff_z1(i)*rmref/Aref
             p   = (rho/rhoin)**rkappa*pref
             dv = (aeff_z1(i)-aeff(i))*aref*dx*D
             if (p/pref.gt.pout) workloss=workloss-(p-pout*pref)*dv
             work=work-p*dv
 315  continue

       
C Sicherstellung der CFL Bedingung
      geschwmax=0
      do 320 i=1,nx
         v=unew_z1(2,i)
         geschw=dabs(v)+dsqrt(epsilon*(rkappa-1)/Aeff_z1(i)**
     *        (rkappa-1))*unew_z1(1,i)**((rkappa-1)/2.0d0)
         if (geschw.gt.geschwmax) geschwmax = geschw
 320  continue

      dt1 = dx/geschwmax*cfl
      dt = dt1



      do 410 i=0,NX+3
         do 410 j=1,2
            uold_z1(j,i)=unew_z1(j,i)

 410     continue
      
      do 420 i=0,NXl+1
         do 420 j=1,2
            uold_l(j,i)=unew_l(j,i)         
 420  continue
c      write (*,*) t,h,istatev(1),istatev(2),istatev(3),istatev(4),dx,dt
      return
      end

    
  

c -----------------------------------------------------------------------
      


      subroutine fwave (ul,ur,al,ar,zplus,zminus)
      implicit real*8 (A-H,O-Z)
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      dimension ul(2),ur(2),e(2,2),einv(2,2),P(2,2,2),f(2)
      dimension a1(2),a2(2)
      dimension zplus(2),zminus(2),fr(2)
      
c definition der analytischen flussfunktionen      
      
      F1 (R,U) = R*U
      F2 (R,U,A) = U*U/2.d0 +
     *   epsilon*(R/A)**(rkappa-1.d0)

C u vector of state quantities 
c u(1)   mass         per unit length
c u(2)   velocity

C ratio of specifc heat capacities
      rk=rkappa
    
C velocities 
      vl = ul(2)
      vr = ur(2) 
      rl = ul(1)
      rr = ur(1)
      
c schallgeschwindigkeiten

      cl = dsqrt(epsilon*(rk-1)/al**(rk-1)*rl**(rk-1))
      cr = dsqrt(epsilon*(rk-1)/ar**(rk-1)*rr**(rk-1))
      
c eigenvektoren
      
      a1(1) = 1
      a1(2) = -cl/rl

      a2(1) = 1
      a2(2) = cr/rr

c berechnen der flussdifferenzen
      Fr(1) = F1(ur(1),ur(2))-F1(ul(1),ul(2)) 
      Fr(2) = F2(ur(1),ur(2),ar)-F2(ul(1),ul(2),al) 
      

C berechnen der projektionen beta1 und beta2

      beta2 = (Fr(1)-Fr(2)/a1(2)*a1(1))/(a2(1)-a2(2)/a1(2)*a1(1))
      beta1 = (Fr(2)-beta2*a2(2))/a1(2)

c berechnen der fluesse

      do 10 j=1,2
         zplus(j)  = beta2 * a2(j)
         zminus(j) = beta1 * a1(j)
 10   continue

     
      

      
      return
      end


c-------------------------------------------------------------------------



      subroutine fwaves (ul,ur,al,ar,s,zplus,zminus)
      implicit real*8 (A-H,O-Z)

      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /referenz/ rmref, riref, pref, tref, Aref, epsilon

      dimension ul(2),ur(2),e(2,2),einv(2,2),P(2,2,2),f(2)
      dimension a1(2),a2(2)
      dimension zplus(2),zminus(2),fr(2)
      
c definition der analytischen flussfunktionen      
      
      F1 (R,U) = R*U
      F2 (R,U,A) = U*U/2.d0 +
     *   epsilon*(R/A)**(rkappa-1.d0)

C u vector of state quantities 
c u(1)   mass         per unit length
c u(2)   velocity

C ratio of specifc heat capacities
      rk=rkappa
    
C velocities 
      vl = ul(2)
      vr = ur(2) 
      rl = ul(1)
      rr = ur(1)
      
c schallgeschwindigkeiten

      cl = dsqrt(epsilon*(rk-1)/al**(rk-1)*rl**(rk-1))
      cr = dsqrt(epsilon*(rk-1)/ar**(rk-1)*rr**(rk-1))
      
c eigenvektoren
      
      a1(1) = 1
      a1(2) = -cl/rl

      a2(1) = 1
      a2(2) = cr/rr

c berechnen der flussdifferenzen
      Fr(1) = F1(ur(1),ur(2))-F1(ul(1),ul(2))-s 
      Fr(2) = F2(ur(1),ur(2),ar)-F2(ul(1),ul(2),al) 
      

C berechnen der projektionen beta1 und beta2

      beta2 = (Fr(1)-Fr(2)/a1(2)*a1(1))/(a2(1)-a2(2)/a1(2)*a1(1))
      beta1 = (Fr(2)-beta2*a2(2))/a1(2)

c berechnen der fluesse

      do 10 j=1,2
         zplus(j)  = beta2 * a2(j)
         zminus(j) = beta1 * a1(j)
 10   continue

      if (vl.gt.cl) then
         do 20 j=1,2
            zplus(j)=Fr(j)
            zminus(j)=0.0d0
  20     continue
      else if (vr.lt.-cr) then
         do 30 j=1,2
            zplus(j)=0.0d0
            zminus(j)=Fr(j)
  30     continue
      endif
      
      return
      end


c-------------------------------------------------------------------------
      subroutine calcvalves(uold_z1,uold_l,aeff_z1,
     *     aeff_l,xold,xold2,xnew,vvalve,avalve,istatev,rmdot)
      implicit real*8 (A-H,O-Z)
      parameter (NXX=2000)
      dimension uold_z1(2,0:NXX),unew_z1(2,0:NXX), Aeff_z1(0:nxx)
      dimension uold_l(2,0:NXX),unew_l(2,0:NXX), Aeff_l(0:nxx)
      dimension xold2(4),xold(4),xnew(4),rmdot(4),Avalve(4),istatev(4)
      dimension ul(2),ur(2)
      dimension vvalve(4)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin
      

      do 10 j=1,2
         ul(j)=uold_z1(j,nxz-1)
         ur(j)=uold_z1(j,nxz+4)
 10   continue
      call ventil (ul,ur,Aeff_z1(nxz),Aeff_z1(nxz+3),xold(2),xold2(2),
     *     1,xnew(2),vvalve(2),avalve(2),istatev(2),rmdot(2))
      do 20 j=1,2
         ul(j)=uold_z1(j,1)
         ur(j)=uold_z1(j,1)
 20   continue
      call ventil (ul,ur,Aeff_z1(1),Aeff_z1(1),xold(1),xold2(1),
     *     -1,xnew(1),vvalve(1),avalve(1),istatev(1),rmdot(1))

     
      return
      end


     
c -----------------------------------------------------------------------
      subroutine Ausstroem1 (ul,ubold,al,ab,pout,ubnew) 
      implicit real*8 (A-H,O-Z)
      parameter (NXX=2000)
      dimension ubold(2),ubnew(2),F(2),DF(2,2),fnum(2),ul(2),
     *           FP(2),FM(2),ubnewm(2),ubnewp(2),du(2),ur(2)
      dimension unew(2,0:nxx)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
c      common /rand/ pout, pin, rhoin
     
      do 10 j=1,2
         ubnew(j)=ubold(j)
 10   continue



      hh = 1.d-3
      DO 20 II=1,10
         

         do 21 I=1,2
            DO 22 J=1,2
            ubnewm(j)=ubnew(j)
 22         ubnewp(j)=ubnew(j)
         ubnewm(i)=ubnew(i) - hh
         ubnewp(i)=ubnew(i) + hh
         call Downwind (ul,ubnewm,ubold,al,ab,pout,Fm)
         call Downwind (ul,ubnewp,ubold,al,ab,pout,Fp)
       

         do 21 j=1,2 
 21         df(j,i)=(fp(j)-fm(j))/(ubnewp(i)-ubnewm(i)) 



         call Downwind (ul,ubnew,ubold,al,ab,pout,F)


         
         DET  = df(1,1)*df(2,2)-df(2,1)*df(1,2)
          
         du(1)=(F(1)*df(2,2) - F(2)*df(1,2))/DET   
          
         du(2)=(df(1,1)* F(2)-df(2,1)*F(1))/DET
 
         do 24 j=1,2
 24         ubnew(j)=ubnew(j)-du(j)
 20      continue
c         write(*,*) ur(1),ur(2)
         call Downwind (ul,ubnew,ubold,al,ab,pout,F)



         
         return
         end
C___________________________________________________________________________


      subroutine Downwind (ul,ubnew,ubold,al,ab,pout,ff)
      parameter (NXX=2000)
      implicit real*8(A-H,O-Z)
      dimension ul(2),ubold(2),ubnew(2),fnum(2),feul(2),
     *          FF(2),ubstar(2)
      dimension dadt(0:nxx), dadx (0:nxx), aeff(0:nxx) 
      dimension unew(2,0:nxx)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
c      common /rand/ pout, pin, rhoin

         

c riemann invariante berechnen

      F(R,u,A)= u + dsqrt(epsilon*(rkappa-1)*(R/A)**(rkappa-1))


c gleichungen

      FF(1)=(ubnew(1)/Ab)**rkappa-pout
      if (ubnew(2).gt.0) then
         FF(1)=(ubnew(1)/Ab)**rkappa-pout-(ubnew(1)/Ab)*0.5*
     *        ubnew(2)**2*rmref/aref*riref**2/pref
      else
         FF(1)=(ubnew(1)/Ab)**rkappa-pout+(ubnew(1)/Ab)*0.5*
     *        ubnew(2)**2 
      endif
      wbold = 0.5d0*F(ubold(1),ubold(2),ab)
      wl    = 0.5d0*F(ul(1),ul(2),al)
      wbnew = 0.5d0*F(ubnew(1),ubnew(2),ab)
      
      FF(2)=wbnew-wbold-wbold*2.0d0*dt/dx*(wl-wbold)
   



      

      return
      end      


c ------------------------------------------------------------------------


      subroutine verzweigung (uold1,uold2,uold3,ul1,ul2,ur3,
     *        a1,a2,a3,al1,al2,ar3,ur,t)
      implicit real*8 (A-H,O-Z)
c      parameter (NXX=2000)
      dimension F(3),DF(3,3),FP(3),FM(3),du(3)
      dimension urm(3),urp(3)
      dimension ur(3),uold1(2),uold2(2),uold3(2),ul1(2),ul2(2),ur3(2)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin

c ur ist der vektor bestehend aus u1, u2, R1
c die restliche variabeln u3,r2,r3 werden bestimmt


      ur(1)    = uold1(2)
      ur(2)    = uold2(2)
      ur(3)    = uold1(1)

      hh = 1.d-2
      DO 20 II=1,50


         do 21 I=1,3
            DO 22 J=1,3
            urm(j)=ur(j)
22          urp(j)=ur(j)
         urm(i)=ur(i) - hh
         urp(i)=ur(i) + hh
         call gleichung (urm,uold1,uold2,uold3,ul1,ul2,ur3,
     *        a1,a2,a3,al1,al2,ar3,Fm)
         call gleichung (urp,uold1,uold2,uold3,ul1,ul2,ur3,
     *        a1,a2,a3,al1,al2,ar3,Fp)



         do 21 j=1,3
 21         df(j,i)=(fp(j)-fm(j))/(urp(i)-urm(i))



         call gleichung (ur,uold1,uold2,uold3,ul1,ul2,ur3,
     *        a1,a2,a3,al1,al2,ar3,F)



          DET  = df(1,1)*df(2,2)*df(3,3)-df(1,1)*df(3,2)*df(2,3)
     *         + df(2,1)*df(3,2)*df(1,3)-df(2,1)*df(1,2)*df(3,3)
     *         + df(3,1)*df(1,2)*df(2,3)-df(3,1)*df(2,2)*df(1,3)
     *

          du(1)=(F(1)   *df(2,2)*df(3,3)- F(1)  *df(3,2)*df(2,3)
     *         + F(2)   *df(3,2)*df(1,3)- F(2)  *df(1,2)*df(3,3)
     *         + F(3)   *df(1,2)*df(2,3)- F(3)  *df(2,2)*df(1,3))/DET

          du(2)=(df(1,1)* F(2)  *df(3,3)-df(1,1)*F(3)   *df(2,3)
     *         + df(2,1)* F(3)  *df(1,3)-df(2,1)*F(1)   *df(3,3)
     *         + df(3,1)* F(1)  *df(2,3)-df(3,1)*F(2)   *df(1,3))/DET

          du(3)=(df(1,1)*df(2,2)*F(3)   -df(1,1)*df(3,2)*F(2)
     *         + df(2,1)*df(3,2)*F(1)   -df(2,1)*df(1,2)*F(3)
     *         + df(3,1)*df(1,2)*F(2)   -df(3,1)*df(2,2)*F(1))/DET
          do 24 j=1,3
             ur(j)=ur(j)-du(j)
c             write(*,*) du(j)
 24       continue
 20       continue


c      write (93, *) t,ur(1), ur(2), ur (3)


       return
       end
C___________________________________________________________________________


      subroutine gleichung (ur,uold1,uold2,uold3,ul1,ul2,ur3,
     *        a1,a2,a3,al1,al2,ar3,FF)
      parameter (NXX=2000)
      implicit real*8(A-H,O-Z)
      dimension ur(3),uold1(2),uold2(2),uold3(2),ul1(2),ul2(2),ur3(2),
     *          FF(3)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin


c riemann invariante

      F1(R,u,A)= u - dsqrt(epsilon*(rkappa-1)*(R/A)**(rkappa-1))
      F2(R,u,A)= u + dsqrt(epsilon*(rkappa-1)*(R/A)**(rkappa-1))

c rohr1:
      R1 = ur(3)
      u1 = ur(1)

      wbold = 0.5d0*F2(uold1(1),uold1(2),a1)
      wl    = 0.5d0*F2(ul1(1),ul1(2),al1)
      wbnew = 0.5d0*F2(R1,u1,a1)

      FF(1)=wbnew-wbold-wbold*2.0d0*dt/dx*(wl-wbold)

c rohr2:
c      R2 = R1*A2/A1
c      u2 = ur(2)

c      wbold = 0.5d0*F2(uold2(1),uold2(2),a2)
c      wl    = 0.5d0*F2(ul2(1),ul2(2),al2)
c      wbnew = 0.5d0*F2(R2,u2,a2)

c      FF(2)=wbnew-wbold-wbold*2.0d0*dt/dx*(wl-wbold)

c aenderung aufgrund der konfiguration
      R2 = R1*A2/A1
      u2 = ur(2)

      wbold = 0.5d0*F1(uold2(1),uold2(2),a2)
      wr    = 0.5d0*F1(ul2(1),ul2(2),al2)
      wbnew = 0.5d0*F1(R2,u2,a2)

      FF(2)=wbnew-wbold-wbold*2.0d0*dt/dx*(wbold-wr)



c rohr3:
      R3 = R1*A3/A1
c      u3 = (R1*u1+R2*u2)/R3
      u3 = (R1*u1-R2*u2)/R3


      wbold = 0.5d0*F1(uold3(1),uold3(2),a3)
      wr    = 0.5d0*F1(ur3(1),ur3(2),ar3)
      wbnew = 0.5d0*F1(R3,u3,a3)

      FF(3)=wbnew-wbold-wbold*2.0d0*dt/dx*(wbold-wr)




      return
      end
c----------------------------------------------------------------------------

      


      subroutine berechnezustand (x,Time,Uakt,aeff,p,rho,Temp)
      implicit real*8(A-H,O-Z)
      parameter (NXX=2000)
      dimension  Uakt(2,0:NXX), Aeff(0:nxx)
      dimension dadt(0:nxx), dadx (0:nxx)
      character FILE*8
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin

      
      I= X/dx/d+1 
      rho = uakt(1,I)/aeff(i)/Aref*rmref    
      p   =  (rho/rhoin)**rkappa*pref
      Temp   =  p/rho/R
      return
      end
      
c -------------------------------------------------------------------------
      subroutine initarea(t,Aeff_z1,Aeff_l)
      implicit real*8(A-H,O-Z)
      parameter (NXX=2000)
      dimension aeff_z1(0:nxx),aeff_l(0:nxx)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin

      PI=3.141592653589793238


c definition lengths and areas
      
      rlventg1 = vp_l3
      rlventk  = vp_l2
      rlventg2 = vp_l1
      rlvent   = rlventg1+rlventk+rlventg2
      rlventu  = cp_l
c length of pressure tube 
      rllaterne = vr_lr1
c length of pressure tank
      rlleitung = vr_lp1
c areas
      aventk1  = vp_a3
      aventk2  = vp_a1
      alaterne = vr_ar1
      aleitung = vr_ap1
      
      if (nvr.eq.2) then
         rllaterne=rllaterne/3.*4.
      endif
      
c calculate current height
      call hoehe(t,h,dhdt,phi)      
      h2=(2*rkr+2*h0)/h0-h      
      bmin = vp_ws
      if (rnvalve.eq.2) bmin=0.7*D/2.0d0
      amin1=bmin*h*h0
      amin2=bmin*h2*h0
      if (amin1.gt.aventk2) amin1=aventk2
      if (amin2.gt.aventk2) amin2=aventk2
     
c calculate dx
      dx=(2*rlvent + D + rllaterne)/D/nx
      dt=0.01*dx    
      dxdim=dx*D

      nxd1=(rlvent)/D/dx+1
      nxd2=(rlvent+rlventu)/D/dx+1
      
      
      nx1=(rlventg1)/D/dx+1
      nx2=(rlventg1+rlventk)/dxdim+1
      nx3=(rlvent)/dxdim+1
      nx4=(rlvent+rlventu)/dxdim+1

      nxz=(2*rlvent + D)/D/dx+1
      nxl=rlleitung/dxdim+1
      nxt=nxz+(nx-nxz)/2.


c (const. cross section):

      do 10 i=0, nx1
         Aeff_z1(i)=Aventk1/Aref

 10   continue

c ventilnest erweiterung
      do 20 i=nx1+1, nx2
         Aeff_z1(i)=(Aventk1+(Aventk2-Aventk1)/(nx2-nx1-1)*
     *      (i-nx1-1))/Aref

 20   continue

c ventilnest (cross section)
      do 30 i=nx2+1, nx3
         Aeff_z1(i)=Aventk2/Aref

 30   continue

c cylinder
      do 45 i=nx3+1, nxz-nx3
         xdim=(i-1)*dxdim
         bdim=2*sqrt((d/2)**2-(d/2+rlvent-xdim)**2)
         Aeff_z1(i)=h*bdim/D/rnvalve

         if (Aeff_z1(i).lt.Amin1/Aref) Aeff_z1(i)=Amin1/Aref

 45   continue
  
      if (ncp.eq.1) then
         do 46 i=nxd1+1, nxd2
            xdim=(i-1)*dx*d
            bdim=2*sqrt((d/2)**2-(d/2+rlvent-xdim)**2)
            Aeff_z1(i)=h*bdim/D+cp_A/Aref

 46      continue
      
         do 47 i=nxz-nxd2, nxz-nxd1
            xdim=(i-1)*dx*d
            bdim=2*sqrt((d/2)**2-(d/2+rlvent-xdim)**2)
            Aeff_z1(i)=h*bdim/D+cp_A/Aref

 47      continue
      endif

      do 50 i=nxz-nx3+1, nxz-nx2
         Aeff_z1(i)=Aventk2/Aref

 50   continue  
   
      do 60 i=nxz-nx2+1, nxz-nx1
         Aeff_z1(i)=(Aventk2+(Aventk1-Aventk2)/(-nx1-1+nx2)*
     *      (i-nxz+nx2-1))/Aref

 60   continue

      do 70 i=nxz-nx1+1, nxz+1
         Aeff_z1(i)=Aventk1/Aref

 70   continue
  
c flaeche der laterne bestimmen
     
      do 80 i=nxz+2, nx+3
         Aeff_z1(i)=Alaterne/Aref
 80   continue 



c verkleinerte flaeche laterne wenn nur laterne
      if (nvr.eq.2) then
         do 85 i=int(nxz+(3./4.)*(nx-nxz)), nx+3
            Aeff_z1(i)=Alaterne/Aref/4.0
 85      continue
      endif
c flaeche der druckrohrleitung

      do 90 i=0, nxl+1
         Aeff_l(i)=Alaterne/Aref/1.5               
 90   continue 

      do 95 i=nxl/10, nxl+1
         Aeff_l(i)=Aleitung/Aref
 95   continue 


      do 100 i=nxl*9/10, nxl+1
         Aeff_l(i)=Alaterne/Aref/4.             
 100  continue 

      return
      end

c____________________________________________________________________
      
      subroutine ventil (ul,ur,Al,Ar,xalt,xalt2,ivalve,xneu,v,
     *     avalve,istatev,rmdot)
      implicit real*8(a-h,o-z)
      parameter (NXX=2000)
      dimension ul(2),ur(2)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca
      common /probe/ vfc
      
      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin
     

      
c ruhedruck berechnen

      F(p,rh,u)=((p/rh/(1.-1./rkappa)+u**2.0d0/2.0d0)*
     *     (1.-1./rkappa)*rh/p**(1/rkappa))**(rkappa/(rkappa-1))



c properties of the valve
 
      if (ivalve.eq.-1) then
         rkfeder=sv_c
         alpha=sv_alpha
         beta=sv_beta
         Akraft=sv_af
         vorspann=sv_l1
         rmasseventil=sv_m
         femm=sv_femm
         xmax=sv_xvmax
         rmue=sv_mue
         spaltl=sv_gap
         umfang=sv_disp
         xv0=sv_xv0
         pf=sv_pf
      else
         rkfeder=dv_c
         alpha=dv_alpha
         beta=dv_beta
         Akraft=dv_af
         vorspann=dv_l1
         rmasseventil=dv_m
         femm=dv_femm
         xmax=dv_xvmax
         rmue=dv_mue
         spaltl=dv_gap
         umfang=dv_disp
         xv0=dv_xv0
         pf=dv_pf
      endif


      xalt2=xalt
      xalt=xneu
      valt=v

      rhoref=rmref/Aref
      rho = ul(1)/Al*rmref/Aref
      plalt   = (rho/rhoref)**rkappa*pref
      ulalt = ul(2)*riref
      plalt0 = F(plalt,rho,ulalt)
      rhol0=rho*(plalt0/plalt)**(1/rkappa)
      

      rho     = ur(1)/Ar*rmref/Aref
      pralt   = (rho/rhoref)**rkappa*pref
      uralt   = ur(2)*riref
      pralt0  =  pralt
      rhor0   = rho


      if (ivalve.eq.-1) then
         plalt=pin*pref
         plalt0=pin*pref
         rhol0=rhoin
      endif

c nur wenn entkoppelung von laterne gewuenscht
      if (nvr.eq.0) then
         if (ivalve.eq.1) then
            pralt0=pout*pref
            rhor0=rhol0
            pralt=pout*pref
            rhor=rhol0
         endif
      endif
c -------
      fventil   = (plalt-pralt)*Akraft
c      fventil   = (plalt-pralt)*Akraft*(1.-0.2*xneu/xmax)


      fspalt=rmue*spaltl**3.*valt/xalt**3.*umfang
      if (xalt.gt.xv0) then 
c         write (99,*) fspalt,fventil
         fventil=fventil-fspalt
      endif
c      if (fspalt.lt.10*fventil) then 
c         write (99,*) xalt, valt, fspalt, fventil
c         fventil=fventil-fspalt
c      endif
     
 
c      v=valt+(fventil-rkfeder*(xalt+vorspann))/
c     *     rmasseventil*(dt*tref)
c      xneu=xalt+valt*tref*dt+(fventil-rkfeder*(xalt+vorspann))
c     *     /rmasseventil*(dt*tref)**2/2






c genaue loesung
      v=valt*cos(dsqrt(rkfeder/rmasseventil)*dt*tref)+dsqrt(1.0d0/
     *     rmasseventil/rkfeder)*(fventil-rkfeder*(vorspann+
     *     xalt))*sin(dsqrt(rkfeder/rmasseventil)*dt*tref)
      xneu=1.0d0/rkfeder*(fventil-rkfeder*vorspann+(rkfeder*(vorspann+
     *     xalt)-
     *     fventil)*cos(dsqrt(rkfeder/rmasseventil)*dt*tref)+
     *     dsqrt(rkfeder*rmasseventil)*valt*sin(dsqrt(rkfeder/
     *     rmasseventil)*dt*tref))


     
      if (xneu.gt.xmax) then 
         xneu=xmax
         v=0.0d0
      endif
      if (xneu.le.xv0) then 
         xneu=xv0
         v=0.0d0
      endif
      if (xneu.le.xv0) then
         istatev = 0
         rmdot    = 0.0d0
         avalve  = 0.0d0
         
      else
c         write(99,*) plalt,pralt,xneu
         istatev = 1
         hventil = xneu
         Avalve=pf*
     *          dsqrt((femm*hventil)**2/(alpha+beta*hventil**2))

c berechnen des massenstroms
         pdiff=pralt/plalt
         if (pdiff.lt.1) then
            epsi=dsqrt(rkappa/(rkappa-1)*(pdiff**(2/rkappa)-pdiff**
     *           ((rkappa+1)/rkappa))/(1-pdiff))            
                   
            rmdot = Avalve*epsi*dsqrt(2.0d0*rhol0*(plalt0-
     *        pralt0))
            rmdot = Avalve*rhol0*pdiff**(1/rkappa)*dsqrt(
     *           2.*rkappa/(rkappa-1)*plalt0/rhol0*(1.-
     *           pdiff**((rkappa-1.)/rkappa)))
            
         else if (pdiff.gt.1) then        
            pdiff = plalt0/pralt0 
            epsi=dsqrt(rkappa/(rkappa-1)*(pdiff**(2/rkappa)-pdiff**
     *        ((rkappa+1)/rkappa))/(1-pdiff))   
            rmdot = -Avalve*epsi*dsqrt(2.0d0*rhor0*
     *       dabs(plalt0-pralt0))
         end if

c umspeichern in dimensionslose form
         Avalve = Avalve/Aref
         rmdot  = rmdot/rmref/riref
         rho2=rho*(pralt/plalt)**(1/rkappa)
         u=rmdot*rmref*riref/Avalve/aref/rho2
c         write(97,*) pdiff,plalt, pralt,rmdot 
      endif

      return
      end      



c------------------------------------------------------------------------

      subroutine ausstroem2(ul,Al,rmdota)
      implicit real*8(a-h,o-z)
      parameter (NXX=2000)
      dimension ul(2),ur(2)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin
     

      
c ruhedruck berechnen

     

      rhoref=rmref/Aref
      rhol = ul(1)/Al*rmref/Aref
      plalt   = (rhol/rhoref)**rkappa*pref
     
      pralt=pout*pref
      rhor=rhol 

      Avalve=Al*Aref/4.

c berechnen des massenstroms
      pdiff=pralt/plalt
      if (pdiff.lt.1) then
         epsi=dsqrt(rkappa/(rkappa-1)*(pdiff**(2/rkappa)-pdiff**
     *        ((rkappa+1)/rkappa))/(1-pdiff))            
         
         rmdota = Avalve*epsi*dsqrt(2.0d0*rhol*(plalt-
     *        pralt))
         
      else if (pdiff.gt.1) then        
         pdiff = plalt/pralt 
         epsi=dsqrt(rkappa/(rkappa-1)*(pdiff**(2/rkappa)-pdiff**
     *        ((rkappa+1)/rkappa))/(1-pdiff))   
         rmdota = -Avalve*epsi*dsqrt(2.0d0*rhor*
     *        dabs(plalt-pralt))
      end if

c umspeichern in dimensionslose form         
         rmdota  = rmdota/rmref/riref
         
      return
      end          


c -----------------------------------------------------------------------
      subroutine Ausstroem3 (ul,ubold,al,ab,rmdotb,ubnew) 
      implicit real*8 (A-H,O-Z)
      parameter (NXX=2000)
      dimension ubold(2),ubnew(2),F(2),DF(2,2),fnum(2),ul(2),
     *           FP(2),FM(2),ubnewm(2),ubnewp(2),du(2),ur(2)
      dimension unew(2,0:nxx)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin
     
      do 10 j=1,2
         ubnew(j)=ubold(j)
 10   continue



      hh = 1.d-3
      DO 20 II=1,10
         

         do 21 I=1,2
            DO 22 J=1,2
            ubnewm(j)=ubnew(j)
 22         ubnewp(j)=ubnew(j)
         ubnewm(i)=ubnew(i) - hh
         ubnewp(i)=ubnew(i) + hh
         call Downwind3 (ul,ubnewm,ubold,al,ab,rmdotb,Fm)
         call Downwind3 (ul,ubnewp,ubold,al,ab,rmdotb,Fp)
       

         do 21 j=1,2 
 21         df(j,i)=(fp(j)-fm(j))/(ubnewp(i)-ubnewm(i)) 



         call Downwind3 (ul,ubnew,ubold,al,ab,rmdotb,F)


         
         DET  = df(1,1)*df(2,2)-df(2,1)*df(1,2)
          
         du(1)=(F(1)*df(2,2) - F(2)*df(1,2))/DET   
          
         du(2)=(df(1,1)* F(2)-df(2,1)*F(1))/DET
 
         do 24 j=1,2
 24         ubnew(j)=ubnew(j)-du(j)
 20      continue
c         write(*,*) du(1),du(2),rmdotb*riref*rmref,ubnew(2)*riref
         call Downwind3 (ul,ubnew,ubold,al,ab,rmdotb,F)



         
         return
         end
C___________________________________________________________________________


      subroutine Downwind3 (ul,ubnew,ubold,al,ab,rmdotb,ff)
      parameter (NXX=2000)
      implicit real*8(A-H,O-Z)
      dimension ul(2),ubold(2),ubnew(2),fnum(2),feul(2),
     *          FF(2),ubstar(2)
      dimension dadt(0:nxx), dadx (0:nxx), aeff(0:nxx) 
      dimension unew(2,0:nxx)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin

         

c riemann invariante berechnen

      F(R,u,A)= u + dsqrt(epsilon*(rkappa-1)*(R/A)**(rkappa-1))


c gleichungen

      FF(1)=ubnew(1)*ubnew(2)-rmdotb


      wbold = 0.5d0*F(ubold(1),ubold(2),ab)
      wl    = 0.5d0*F(ul(1),ul(2),al)
      wbnew = 0.5d0*F(ubnew(1),ubnew(2),ab)
      
      FF(2)=wbnew-wbold-wbold*2.0d0*dt/dx*(wl-wbold)
c      FF(2)=ubnew(1)-ul(1)



      

      return
      end      


c ------------------------------------------------------------------------
      subroutine Ausstroem4 (ur,ubold,ar,ab,rmdotb,ubnew) 
      implicit real*8 (A-H,O-Z)
      parameter (NXX=2000)
      dimension ubold(2),ubnew(2),F(2),DF(2,2),fnum(2),ul(2),
     *           FP(2),FM(2),ubnewm(2),ubnewp(2),du(2),ur(2)
      dimension unew(2,0:nxx)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin
     
      do 10 j=1,2
         ubnew(j)=ubold(j)
 10   continue



      hh = 1.d-3
      DO 20 II=1,10
         

         do 21 I=1,2
            DO 22 J=1,2
            ubnewm(j)=ubnew(j)
 22         ubnewp(j)=ubnew(j)
         ubnewm(i)=ubnew(i) - hh
         ubnewp(i)=ubnew(i) + hh
         call Downwind3 (ur,ubnewm,ubold,ar,ab,rmdotb,Fm)
         call Downwind3 (ur,ubnewp,ubold,ar,ab,rmdotb,Fp)
       

         do 21 j=1,2 
 21         df(j,i)=(fp(j)-fm(j))/(ubnewp(i)-ubnewm(i)) 



         call Downwind3 (ur,ubnew,ubold,ar,ab,rmdotb,F)


         
         DET  = df(1,1)*df(2,2)-df(2,1)*df(1,2)
          
         du(1)=(F(1)*df(2,2) - F(2)*df(1,2))/DET   
          
         du(2)=(df(1,1)* F(2)-df(2,1)*F(1))/DET
 
         do 24 j=1,2
 24         ubnew(j)=ubnew(j)-du(j)
 20      continue
c         write(*,*) ur(1),ur(2)
         call Downwind3 (ur,ubnew,ubold,ar,ab,rmdotb,F)



         
         return
         end
C___________________________________________________________________________


      subroutine Downwind4 (ur,ubnew,ubold,ar,ab,rmdotb,ff)
      parameter (NXX=2000)
      implicit real*8(A-H,O-Z)
      dimension ur(2),ubold(2),ubnew(2),fnum(2),feul(2),
     *          FF(2),ubstar(2)
      dimension dadt(0:nxx), dadx (0:nxx), aeff(0:nxx) 
      dimension unew(2,0:nxx)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin

         

c riemann invariante berechnen

 
      F1(R,u,A)= u - dsqrt(epsilon*(rkappa-1)*(R/A)**(rkappa-1))

c gleichungen
     
      FF(1)=ubnew(1)*ubnew(2)-rmdotb



      wbold = 0.5d0*F1(ubold(1),ubold(2),ab)
      wr    = 0.5d0*F1(ur(1),ur(2),ar)
      wbnew = 0.5d0*F1(ubnew(1),ubnew(2),ab)

      FF(2)=wbnew-wbold-wbold*2.0d0*dt/dx*(wbold-wr)
c      FF(2)=ubnew(1)-ur(1)



      

      return
      end      


c ------------------------------------------------------------------------
      subroutine mcc (t,uold_z1,unew_z1,Aeff_z1,rmdot)
      implicit real*8(a-h,o-z)
      parameter (NXX=2000)
      dimension uold_z1(2,0:NXX),unew_z1(2,0:NXX), Aeff_z1(0:nxx)
      dimension uhalf_z1(2,0:NXX)
      dimension fm(2),fl(2),fr(2)
      dimension rmdot(4)

      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca
      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin
      common /periodic/ rmgesamt, vmax, work, workloss

      F1 (R,U) = R*U
      F2 (R,U,A) = U*U/2.d0 +
     *   epsilon*(R/A)**(rkappa-1.d0)



      call flaeche(t-dt,Aeff_z1,Aeff_l)
      do 10 j=1,nx+2
         s=0.0d0
         if (j.eq.nxz) s=rmdot(2)
         if (j.eq.nxz+3) s=-rmdot(2)
      
c velocity
         vl = uold_z1(2,j-1)
         vm = uold_z1(2,j)
         vr = uold_z1(2,j+1)
c mass R
         rl = uold_z1(1,j-1)
         rm = uold_z1(1,j)
         rr = uold_z1(1,j+1)
c area
         al = aeff_z1(j-1)
         am = aeff_z1(j)
         ar = aeff_z1(j+1)
c predictor
c fluss
         fm(1) = f1(rm,vm)
         fl(1) = f1(rl,vl)
         fm(2) = f2(rm,vm,am)
         fl(2) = f2(rl,vl,al)

c     neue werte
         rm=rm-dt/dx*(fm(1)-fl(1)+s)
         vm=vm-dt/dx*(fm(2)-fl(2))
         uhalf_z1(1,j)=rm
         uhalf_z1(2,j)=vm
 10   continue
      uhalf_z1(1,0)=uhalf_z1(1,1)
      uhalf_z1(2,0)=-uhalf_z1(2,1)
      uhalf_z1(1,nx+3)=uhalf_z1(1,nx+2)
      uhalf_z1(2,nx+3)=-uhalf_z1(2,nx+2)
 
      call flaeche(t,Aeff_z1,Aeff_l)
c corrector
      do 20 j=1,nx+2
         s=0.0d0
         if (j.eq.nxz) s=rmdot(2)
         if (j.eq.nxz+3) s=-rmdot(2)

         vm = uhalf_z1(2,j)
         vr = uhalf_z1(2,j+1)
         rm = uhalf_z1(1,j)
         rr = uhalf_z1(1,j+1)
         am = aeff_z1(j)
         ar = aeff_z1(j+1)


         fm(1) = F1(rm,vm)
         fm(2) = F2(rm,vm,am)
         fr(1) = F1(rr,vr)
         fr(2) = F2(rr,vr,ar)

c neue werte
         rm=0.5*(rm+uold_z1(1,j))-dt/dx/2.0d0*(fr(1)-fm(1)+s)
         vm=0.5*(vm+uold_z1(2,j))-
     *        dt/dx/2.0d0*(fr(2)-fm(2))
         unew_z1(1,j)=rm
         unew_z1(2,j)=vm
 20   continue


      return
      end

c ------------------------------------------------------------------------
      subroutine laxw (t,uold_z1,unew_z1,Aeff_z1,rmdot)
      implicit real*8(a-h,o-z)
      parameter (NXX=2000)
      dimension uold_z1(2,0:NXX),unew_z1(2,0:NXX), Aeff_z1(0:nxx)
      dimension uhalf_z1(2,0:NXX)
      dimension fm(2),fl(2),fr(2)
      dimension rmdot(4)

      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca
      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin
      common /periodic/ rmgesamt, vmax, work, workloss

      F1 (R,U) = R*U
      F2 (R,U,A) = U*U/2.d0 +
     *   epsilon*(R/A)**(rkappa-1.d0)



      call flaeche(t-dt,Aeff_z1,Aeff_l)
      do 10 j=1,nx+2
         s=0.0d0
         if (j.eq.nxz) s=rmdot(2)
         if (j.eq.nxz+3) s=-rmdot(2)

c velocity
         vl = uold_z1(2,j-1)
         vm = uold_z1(2,j)
         vr = uold_z1(2,j+1)
c mass R
         rl = uold_z1(1,j-1)
         rm = uold_z1(1,j)
         rr = uold_z1(1,j+1)
c area
         al = aeff_z1(j-1)
         am = aeff_z1(j)
         ar = aeff_z1(j+1)
c predictor
c fluss
         fm(1) = f1(rm,vm)
         fl(1) = f1(rl,vl)
         fr(1) = f1(rr,vr)
         fm(2) = f2(rm,vm,am)
         fl(2) = f2(rl,vl,al)
         fl(2) = f2(rr,vr,ar)

c     neue werte
         rm=0.5d0*(rl+rr)-dt/dx/2.0d0*(fr(1)-fl(1)+s)
         vm=0.5d0*(vr+vl)-dt/dx/2.0d0*(fr(2)-fl(2))
         uhalf_z1(1,j)=rm
         uhalf_z1(2,j)=vm
 10   continue
      uhalf_z1(1,0)=uhalf_z1(1,1)
      uhalf_z1(2,0)=-uhalf_z1(2,1)
      uhalf_z1(1,nx+3)=uhalf_z1(1,nx+2)
      uhalf_z1(2,nx+3)=-uhalf_z1(2,nx+2)

      call flaeche(t,Aeff_z1,Aeff_l)
c corrector
      do 20 j=1,nx+2
         s=0.0d0
         if (j.eq.nxz) s=rmdot(2)
         if (j.eq.nxz+3) s=-rmdot(2)

         vl = uhalf_z1(2,j-1)
         vr = uhalf_z1(2,j+1)
         rl = uhalf_z1(1,j-1)
         rr = uhalf_z1(1,j+1)
         al = aeff_z1(j-1)
         ar = aeff_z1(j+1)


         fl(1) = F1(rl,vl)
         fl(2) = F2(rl,vl,al)
         fr(1) = F1(rr,vr)
         fr(2) = F2(rr,vr,ar)

c neue werte
         rm=uold_z1(1,j)- dt/dx/2.0d0*(fr(1)-fl(1)+s)
         vm=uold_z1(2,j)- dt/dx/2.0d0*(fr(2)-fl(2))
         unew_z1(1,j)=rm
         unew_z1(2,j)=vm
 20   continue


      return
      end

