
c------------------------------------------------------------------
      subroutine root (uold1,uold2,uold3,ul1,ul2,ur3,
     *        a1,a2,a3,al1,al2,ar3,ur,t)
      implicit real*8 (A-H,O-Z)
c      parameter (NXX=2000)

      parameter (ntrial=50,np=6)
      dimension FP(6),FM(6)
      dimension urm(np),urp(np)
      dimension ur(np),uold1(2),uold2(2),uold3(2),ul1(2),ul2(2),ur3(2)
      dimension alpha(np,np),beta(np),indx(np)


      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin

c ur ist der l~sungsvektor bestehend aus u1, R1,u2,R2,u3, R3

      ur(1)    = uold1(1)
      ur(2)    = uold1(2)
      ur(3)    = uold2(1)
      ur(4)    = uold2(2)
      ur(5)    = uold3(1)
      ur(6)    = uold3(2)

c bestimmung der groesse des gleichungssystems
      ngl=6
c kleine aenderung deltah fuer die bestimmung der jakobimatrix
      hh = 1.d-4
      tolx= 1.d-8
      tolf=1.d-8
c starten der iteration, 10 meist ausreichend
      DO 20 II=1,10

c berechnung der jakobi-matrix
         do 21 I=1,ngl
            DO 22 J=1,ngl
            urm(j)=ur(j)
22          urp(j)=ur(j)
         urm(i)=ur(i) - hh
         urp(i)=ur(i) + hh
c berechnung der gleichung
         call gleichung1 (urm,uold1,uold2,uold3,ul1,ul2,ur3,
     *        a1,a2,a3,al1,al2,ar3,Fm)
         call gleichung1 (urp,uold1,uold2,uold3,ul1,ul2,ur3,
     *        a1,a2,a3,al1,al2,ar3,Fp)
         

c berechnen der einzelnen jakobi-elemente
         do 21 j=1,ngl 
            alpha(j,i)=(fp(j)-fm(j))/(urp(i)-urm(i))
 21      continue


c berechnen der urspruenglichen abweichungen beta
         call gleichung1 (ur,uold1,uold2,uold3,ul1,ul2,ur3,
     *        a1,a2,a3,al1,al2,ar3,beta)

         do 23 j=1,ngl 
            beta(j)=-beta(j)
 23      continue

         errf=0.0d0
         do 24 i=1,ngl
            errf=errf+abs(beta(i))
 24      continue
         if (errf.le.tolf) return
c zerlegung der matrix A in L*U
         call ludcmp (alpha,ngl,np,indx,dout)
c loesung des gleichungssystems
         call lubksb (alpha,ngl,np,indx,beta)


c berechnen der neuen werte und bestimmung der fehler
         errx=0.0d0 
         do 25 j=1,ngl
            errx=errx+abs(beta(j))
            ur(j)=ur(j)+beta(j)
c     write(*,*) du(j)
 25      continue
         if (errx.le.tolx) return


 20   continue
      
       return
       end
C___________________________________________________________________________


      subroutine gleichung1 (ur,uold1,uold2,uold3,ul1,ul2,ur3,
     *        a1,a2,a3,al1,al2,ar3,FF)
      parameter (NXX=2000)
      implicit real*8(A-H,O-Z)
      dimension ur(6),uold1(2),uold2(2),uold3(2),ul1(2),ul2(2),ur3(2),
     *          FF(6)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin

c riemann invariante

      F1(R,u,A)= u - dsqrt(epsilon*(rkappa-1)*(R/A)**(rkappa-1))
      F2(R,u,A)= u + dsqrt(epsilon*(rkappa-1)*(R/A)**(rkappa-1))

c rohr1:
      R1 = ur(1)
      u1 = ur(2)
      
      wbold = 0.5d0*F2(uold1(1),uold1(2),a1)
      wl    = 0.5d0*F2(ul1(1),ul1(2),al1)
      wbnew = 0.5d0*F2(R1,u1,a1)
      
      FF(1)=wbnew-wbold-wbold*2.0d0*dt/dx*(wl-wbold)

c rohr2:
      R2 = ur(3)
      u2 = ur(4)
      
c      wbold = 0.5d0*F2(uold2(1),uold2(2),a2)
c      wl    = 0.5d0*F2(ul2(1),ul2(2),al2)
c      wbnew = 0.5d0*F2(R2,u2,a2)
      
c      FF(2)=wbnew-wbold-wbold*2.0d0*dt/dx*(wl-wbold)
      wbold = 0.5d0*F1(uold2(1),uold2(2),a2)
      wr    = 0.5d0*F1(ul2(1),ul2(2),al2)
      wbnew = 0.5d0*F1(R2,u2,a2)

      FF(2)=wbnew-wbold-wbold*2.0d0*dt/dx*(wbold-wr)

c rohr3:
      R3 = ur(5)
      u3 = ur(6)
      
      wbold = 0.5d0*F1(uold3(1),uold3(2),a3)
      wr    = 0.5d0*F1(ur3(1),ur3(2),ar3)
      wbnew = 0.5d0*F1(R3,u3,a3)
      
      FF(3)=wbnew-wbold-wbold*2.0d0*dt/dx*(wbold-wr)
    
c massenerhaltung

      FF(4)=R1*u1-R2*u2-R3*u3

c druckgleichheit

c      FF(5)=R1/A1-R2/A2
c      FF(6)=R2/A2-R3/A3

c energie gleichheit
      const1=rkappa/(rkappa-1)*pref/(rmref/Aref)**rkappa
      
      h1=const1*(R1/A1*rmref/aref)**(rkappa-1)+u1**2./2.0d0*riref**2
      h2=const1*(R2/A2*rmref/aref)**(rkappa-1)+u2**2./2.0d0*riref**2
      h3=const1*(R3/A3*rmref/aref)**(rkappa-1)+u3**2./2.0d0*riref**2

      FF(5)=h1-h2
      FF(6)=h2-h3

      return
      end
c---------------------------------------------------------------------

      subroutine ludcmp(a,n,np,indx,d)
      parameter (nmax=100)
      implicit real*8(A-H,O-Z)
      
     
      
      dimension a(np,np),indx(N),vv(nmax)
      tiny=1.0d-20
      d=1.
      
      do 12 i=1,n
         aamax=0.
         do 11 j=1,n
            if (abs(a(i,j)).gt.aamax) aamax=abs(a(i,j))
 11      continue
         if (aamax.eq.0) pause 'singular matrix'
         vv(i)=1./aamax
 12   continue
      
      do 19 j=1,n
         if (j.gt.1) then 
            do 14 i=1,j-1
               sum=a(i,j)
               if (i.gt.1) then
                  do 13 k=1, I-1
                     sum=sum-A(i,k)*A(k,j)
 13               continue
                  a(i,j)=sum
               endif
 14         continue
         endif
         aamax=0.
         do 16 i=j,n
            sum=a(i,j)
            if (j.gt.1) then
               do 15 k=1,j-1
                  sum=sum-a(i,k)*a(k,j)
 15            continue
               a(i,j)=sum
            endif
            dum=vv(i)*abs(sum)
            if (dum.ge.aamax) then
               imax=i
               aamax=dum
            endif
 16      continue
         if (j.ne.imax) then
            do 17 k=1,n
               dum=a(imax,k)
               a(imax,k)=a(j,k)
               a(j,k)=dum
 17         continue
            vv(imax)=vv(j)
         endif
         indx(j)=imax
         if (j.ne.n) then
            if (a(j,j).eq.0) a(j,j)=tiny
            dum=1./a(j,j)
            do 18 i=j+1,n
               a(i,j)=a(i,j)*dum
 18         continue
         endif
 19   continue
      if (a(n,n).eq.0.) a(n,n)=tiny
      return
      end

c------------------------------------------------------------------------

      subroutine lubksb (a,n,np,indx,b)

     
      implicit real*8(A-H,O-Z)
      
      dimension a(np,np),indx(N),b(n)
      
      ii=0
      do 12 i=1,n
         ll=indx(i)
         sum=b(ll)
         b(ll)=b(i)
         if (ii.ne.0) then 
            do 11 j=ii,i-1
               sum=sum-a(i,j)*b(j)
 11         continue
         else if (sum.ne.0) then
            ii=i
         endif
         b(i)=sum
 12   continue
      do 14 i=n,1,-1
         sum=b(i)
         if (i.lt.n) then
            do 13 j=i+1,n
               sum=sum-a(i,j)*b(j)
 13         continue
         endif
         b(i)=sum/a(i,i)
 14   continue
      return
      end
