
      SUBROUTINE SETPARAM()
      IMPLICIT REAL*8 (A-H,O-Z)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /sensor/ se_d1, se_d2, se_d3
      common /probe/ vfc

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin
      common /crankangle/ endca, repca


C Datenfile einlesen:
      OPEN (10,
     *  FILE='input.inp',
     *     STATUS='OLD',ACCESS='SEQUENTIAL')

c Speed of Crankshaft [rpm]
       read (10,*) rn
c Pressure Inlet [N/m^2]
       read (10,*) pindim
c Pressure Outlet [N/m^2]
       read (10,*) poutdim
c Temperature Inlet [K]
       read (10,*) tindim
c Specific Gas Constant R [J/kgK]
       read (10,*) R
c Ratio of Specific Heats kappa [1]
       read (10,*) rkappa
c Bore [m]
       read (10,*) d
c Stroke [m]
       read (10,*) stroke
       rkr = stroke / 2.0d0
c Piston Rod Diameter [m]
       read (10,*) dpiston
c     Length of Connecting Rod [m]
       read (10,*) pl
c Minimum clearance [m]
       read (10,*) h0
c Number of valves per side [1]
       read (10,*) rnvalve
c Valvepocket 0/1
       read (10,*) nvp
c Minimum Clearance
       read (10,*) vp_ws
c Valve Pocket l1 [m]
       read (10,*) vp_l1
c Valve Pocket A1 [m^2]
       read (10,*) vp_a1
c Valve Pocket l2 [m]
       read (10,*) vp_l2
c Valve Pocket l3 [m]
       read (10,*) vp_l3
c Valve Pocket A3 [m^2]
       read (10,*) vp_a3
c Valveretainer 0/1/2
       read (10,*) nvr
c Valve Retainer lr1 [m]
       read (10,*) vr_lr1
c Cross-Section area Ar1 [m^2]
       read (10,*) vr_ar1
c Valve Retainer lr2 [m]
       read (10,*) vr_lr2
c Pressure Chamber lp1 [m]
       read (10,*) vr_lp1
c Cross-Section area Ap1 [m^2]
       read (10,*) vr_ap1
c Cap Pocket
      read (10,*) ncp
c Cap Pocket l
      read (10,*) cp_l
c Cap Pocket a
      read (10,*) cp_a
c suction Mass valve plate [kg]
       read (10,*) sv_m
c suction Force Area [m^2]
       read (10,*) sv_af
c suction Maximum deflection xvmax [m]
       read (10,*) sv_xvmax
c suction Flow Cross-section 1mm [m^2/m]
       read (10,*) sv_femm
c suction Valve Constant alpha [1/m]
       read (10,*) sv_alpha
c suction Valve Constant beta [1/m^2]
       read (10,*) sv_beta
c suction Initial valve plate lift xv0 [m]
       read (10,*) sv_xv0
c suction Pocket Factor [1]
       read (10,*) sv_pf
c suction Springing Constant c [N/m]
       read (10,*) sv_c
c suction Initial Deflection l1 [m]
       read (10,*) sv_l1
c suction Adhesion Effects
       read (10,*) sv_adh
c suction Dynamic Viscosity  [kg/m/s]
       read (10,*) sv_mue
c suction Gap length [m]
       read (10,*) sv_gap
c suction Average Circumference [m]
       read (10,*) sv_disp
c discharge Mass valve plate [kg]
       read (10,*) dv_m
c discharge Force Area [m^2]
       read (10,*) dv_af
c discharge Maximum deflection xvmax [m]
       read (10,*) dv_xvmax
c discharge Eff. Flow Cross-section 1mm [m^2/m]
       read (10,*) dv_femm
c     discharge Valve Constant alpha [1/m]
       read (10,*) dv_alpha
c discharge Valve Constant beta [1/m^2]
       read (10,*) dv_beta
c discharge Initial valve plate lift xv0 [m]
       read (10,*) dv_xv0
c discharge Pocket Factor [1]
       read (10,*) dv_pf
c discharge Springing Constant c [N/m]
       read (10,*) dv_c
c discharge Initial Deflection l1 [m]
       read (10,*) dv_l1
c discharge Adhesion Effects
       read (10,*) dv_adh
c discharge Dynamic Viscosity  [kg/m/s]
       read (10,*) dv_mue
c discharge Gap length [m]
       read (10,*) dv_gap
c discharge Average Circumference [m]
       read (10,*) dv_disp
c Number of elements [1]
       read (10,*) nx
c CFL - Number [1]
       read (10,*) cfl
c flow constant
       read  (10,*) vfc
c End Crankshaft Angle CA []
       read (10,*) endca
c Reporting Intervall CA []
       read (10,*) repca
c Distance to sensor 1 [m]
       read (10,*) se_d1
       se_d1=se_d1
c Distance to sensor 2 [m]
       read (10,*) se_d2
       se_d2=d+2.0*(vp_l1+vp_l2+vp_l3)-se_d2
c Distance to sensor 3 [m]
       read (10,*) se_d3
       se_d3=d+2.0*(vp_l1+vp_l2+vp_l3)+se_d3
       close(10)

       return
       end
       

c ---------------------------------------------------------------------
c output, in SI-Units, dimension

      subroutine ausgabe1(it,time,u1,u2,u3,aeff_z1,aeff_z2,aeff_l,
     *     xold,xold2,xnew,vvalve,avalve,istatev,rmdot)
      implicit real*8(A-H,O-Z)
      parameter (NXX=2000)
      dimension  U1(2,0:NXX),f(3),UU(3),Aeff_z1(0:nxx)
      dimension u2(2,0:nxx),u3(2,0:nxx),Aeff_z2(0:nxx),Aeff_l(0:nxx)
      dimension xold2(4),xold(4),xnew(4),rmdot(4),Avalve(4),istatev(4)
      dimension vvalve(4)
      character FILE*22
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /gasspec/ R, rkappa, pindim, poutdim, tindim
      common /sv/ sv_m, sv_af, sv_xvmax, sv_femm, sv_alpha, sv_beta,
     *       sv_xv0, sv_c, sv_l1, sv_adh, sv_mue, sv_gap, sv_disp, sv_pf
      common /dv/ dv_m, dv_af, dv_xvmax, dv_femm, dv_alpha, dv_beta,
     *       dv_xv0, dv_c, dv_l1, dv_adh, dv_mue, dv_gap, dv_disp, dv_pf
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /vp_geom/ vp_l1, vp_a1, vp_l2, vp_l3, vp_a3, vp_b, vp_ws
      common /vr_geom/ vr_lr1, vr_ar1, vr_lr2, vr_lp1, vr_ap1
      common /cp_geom/ cp_l, cp_a, ncp
      common /crankangle/ endca, repca
      common /sensor/ se_d1, se_d2, se_d3

      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /rand/ pout, pin, rhoin



      write (FILE,'(''d'',I7.7)') IT
      OPEN (60,FILE=FILE)
      call hoehe(time,h,dhtdt,phi)
      rhoinit= rhoin
      s0=0.d0
      rm0=0.0
      e0=0.d0
      ri0=0.d0
      pges=0.0d0
      pgesx=0.0d0
      aeff0=0.0d0
      DO 110 I=1,NXz
         X= I*dx*d
         rho = u1(1,I)/aeff_z1(i)/Aref*rmref
         rm  = u1(1,I)*rmref *dx *D
         v   = u1(2,I)*riref
         p   =  (rho/rhoin)**rkappa*pref
         T   =  p/rho/R
         pges= pges+p*Aeff_z1(i)*Aref*D*dx
         aeff0=aeff0+aeff_z1(i)
         c   = dsqrt(rkappa*(rkappa-1.d0)*cv*T)
         s   = rm*(rkappa*dlog(T)-(rkappa-1.d0)*dlog(p))
         e   = rm*(cv*T+v*v/2.d0)

         s0=s0  +s /(NXz-1)
         rm0=rm0+rm/(NXz-1)
         e0 =e0 +e /(NXz-1)

 110  continue
      aeff0=aeff0*Aref
      veff0=aeff0*dx*d
      
      fges=0.0d0
      fgesx=0.0d0
      rlvent=vp_l1+vp_l2+vp_l3
      DO 115 I=nxd1,NXz-nxd1
         X= (I-1)*dx*d
         bdim=2*sqrt(dabs((d/2)**2-(d/2+rlvent-x)**2))
         rho = u1(1,I)/aeff_z1(i)/Aref*rmref
         p   =  (rho/rhoin)**rkappa*pref
         fges= fges + p*dx*D*bdim
         fgesx=fgesx+p*(d/2+rlvent-x)*dx*D*bdim
 115  continue
      
      s0 = s0/rm0
      ab = pgesx/pges

      write (60,'(''# Time [s]    = '',G16.3)') Time*tref
      write (60,'(''# Crank_Angle [] = '',G16.3)') phi*180/3.1416
      write (60,'(''# Suct_Valve = '',I1.1)') istatev(1)
      write (60,'(''# Disch_Valve = '',I1.1)') istatev(2)
      write (60,'(''# Height [m] = '',G16.7)') h*h0
      write (60,'(''# '',20A16)')
     *            ' x[m]',' Masse[kg] ',
     *            '  Geschwindigkeit ','flaeche',
     *            '  Dichte [kg/m^3]',
     *            '  speed[m/s] ',' temperature [C]',
     *            '  Druck [N/mm^2] ',' Schallgeschw. [m/s]',
     *            '  Machzahl [1]',' Entropie ',' Gesamtentropie '

      DO 10 I=1,NX+2
         X= (I-1)*dx*d
         rho1 = u1(1,I)/Aeff_z1(i)*rmref/Aref
         v   = u1(2,I)*riref
         if (abs(v).lt.0.1d-95) v=0.0d0
         p1   = (rho1/rhoin)**rkappa*pref
         c   = dsqrt(rkappa*p1/rho1)
         rho2 = u2(1,I)/Aeff_z2(i)*rmref/Aref
         p2   = (rho2/rhoin)**rkappa*pref
         p3 = 0
         s   = 0
         write (60,'(20E16.6)') x,u1(1,i),u1(2,i),aeff_z1(i)*Aref,
     *                          rho,v,T,p,c,v/c,s,s0,p1,p2,p3

 10      continue

         DO 20 I=1,NXl
         X= (I-1)*dx*d+(nx+1)*dx*d
         rho3 = u3(1,I)/Aeff_l(i)*rmref/Aref
         v   = u3(2,I)*riref
         if (abs(v).lt.0.1d-95) v=0.0d0
         p1   = (rho3/rhoin)**rkappa*pref
         p2 = 0
         p3 = 0
         s   = 0
         write (60,'(20E16.6)') x,u3(1,i),u3(2,i),aeff_l(i)*Aref,
     *                          rho,v,T,p,c,v/c,s,s0,p1,p2,p3
 20      continue

      close(60)
      call flush(60)
c zeitverlauefe ausgeben


      x=se_d1
      call berechnezustand(x,t,U1,Aeff_z1,pein,rhoein,Tein)
      x=se_d2
      call berechnezustand(x,t,U1,Aeff_z1,paus,rhoaus,Taus)
      x=(nxz/2.)*dx*D
      call berechnezustand(x,t,U1,Aeff_z1,pmit,rhomit,Tmit)
      x=se_d3
      call berechnezustand(x,t,U1,Aeff_z1,plat,rholat,Tlat)
      x=(nxz-3)*dx*D
      call berechnezustand(x,t,U1,Aeff_z1,pvor,rhovor,Tvor)
      x=(nxz+4)*dx*D
      call berechnezustand(x,t,U1,Aeff_z1,pnach,rhonach,Tnach)

      rmkont=u1(1,nxz-nxd2-3)*u1(2,nxz-nxd2-3)*rmref*riref
      write (90,'(30E16.6)') time*tref,phi*180/3.1415,
     *   rm0,veff0,pges/veff0,pein,paus,pmit,plat,rmdot(1)*rmref*riref,
     *   rmdot(2)*rmref*riref,
     *   xnew(1),xnew(2),vvalve(1),vvalve(2), fgesx, Tmit,
     *     vvalve(3),vvalve(4), Tein,Taus, Tmit, Tlat, pvor,pnach,
     *     rholat, rhonach,rmkont, fges

      return
      end
C___________________________________________________________________________
      subroutine statistic(t,aeff_z1)
      implicit real*8(A-H,O-Z)
      parameter (NXX=2000)
      dimension uold_z1(2,0:NXX),unew_z1(2,0:NXX), Aeff_z1(0:nxx)
      dimension uold_z2(2,0:NXX),unew_z2(2,0:NXX), Aeff_z2(0:nxx)
      dimension uold_l(2,0:NXX),unew_l(2,0:NXX), Aeff_l(0:nxx)
      dimension xold2(4),xold(4),xnew(4),rmdot(4),Avalve(4),istatev(4)
      dimension vvalve(4)
      dimension o(0:nxx),o1(0:nxx)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt

      vmax=0.0d0
      vmin=0.0d0
      do 10 i=1,nxz
         vmax=vmax+dx*D*aeff_z1(i)*Aref
 10   continue
      tmin=0.0d0
      call flaeche(tmin,aeff_z1,o1)
      do 20 i=1,nxz
         vmin=vmin+dx*D*Aeff_z1(i)*Aref
 20   continue
      call flaeche(t,aeff_z1,o1)

      vlost=vmin/vmax*100


      write(96,*) vmax,' Maximum Volume (Cylinder + Valve Pocket)'
      write(96,*) vmin,' Minimum Volume (Cylinder + Valve Pocket)'
      write(96,*) vlost,' Cylinder Clearance [%]: '
      close(96)
      return
      end
c------------------------------------------------------------------------------
      subroutine periode()
      implicit real*8(A-H,O-Z)
      parameter (NXX=2000)
      dimension uold_z1(2,0:NXX),unew_z1(2,0:NXX), Aeff_z1(0:nxx)
      dimension uold_z2(2,0:NXX),unew_z2(2,0:NXX), Aeff_z2(0:nxx)
      dimension uold_l(2,0:NXX),unew_l(2,0:NXX), Aeff_l(0:nxx)
      dimension xold2(4),xold(4),xnew(4),rmdot(4),Avalve(4),istatev(4)
      dimension vvalve(4)
      dimension o(0:nxx),o1(0:nxx)
      common /mainspec/ d, rn, rkr, pl, h0, dpiston, nvp, nvr,
     *        rnvalve
      common /referenz/ rmref, riref, pref, tref, Aref, epsilon
      common /numpar/ cfl, dt, dx, nx, nxz, nxl, nxd1, nxd2, nxt
      common /periodic/ rmgesamt, vmax, work, workloss

      write(98,*) rmgesamt*rmref*riref*tref ,
     *            ' Overall Mass flow per Periode [kg]: '
      write(98,*)  vmax,' Impact velocity (discharge valve) [m/s]: '
      write(98,*)  work,' Total Input Energy per Periode [J]: '
      write(98,*) workloss,' Valve Losses [J]: '
      write(98,*) workloss/work*100.0,' Valve Losses [%] : '
      close(98)
      
      
      return
      end
