clc 
clear variables

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  solve 2D - Burger equation with semi-implicit method
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% space variables
J = 50;    I = 50;  
x_min = 0;  y_min = 0;
x_max = 1;  y_max = 1;
dx = (x_max-x_min)/(J-1);
dy = (y_max-y_min)/(I-1);
[x,y] = meshgrid( x_min:dx:x_max , y_max:-dy:y_min ) ;
N = I*J;

% indices of boundaries
left  = find(x(:)==x_min);
right = find(x(:)==x_max);
bottom= find(y(:)==y_min);
top   = find(y(:)==y_max);

% time variables
t_end = 1e-3;
t     = 0;
dt    = 1e-5;

% iteration number
it =0 ;

%Diffusion coefficient
D = 1e1 ;

% initial condition
U = NaN(N,1);
U(1  :N  ) = 1e-2*exp(-(x(:)-0.5).^2/0.04) .* exp(-(y(:)-0.5).^2/0.04) ;
figure(1);
surf(x,y,reshape(U,I,J));

% Matrix representation of derivatives
e = ones(N,1);
D_x1 = % create matrix form of discrete derivatives
D_y1 = 
D_x2 = 
D_y2 = 
Id = speye(N,N);

% Boundary conditions
D_x1([left;right;bottom;top],:) = %implement Dirichlet boundary conditions
D_y1([left;right;bottom;top],:) = 
D_x2([left;right;bottom;top],:) = 
D_y2([left;right;bottom;top],:) = 

% Matrix of implicit linear terms (Left hand side)
LHS = % compute the matrix of the left hand side

% Time-stepping loop
while t<= t_end
    % plotting the evolution
    surf(x,y,reshape(U,I,J));
    title(['T at t=',num2str(t)])
    drawnow;

    % Matrix of explicit non-linear terms (right hand side)
    RHS = % compute matrix of right hand side

    % Compute the next time step    
    U = % compute the next time step
    t = t+dt;
    it = it+1;
end

