clear variables

% Velocity field
a   = 1 ;                               % Stretching in x
b   = 1 ;                               % Stretching in y
psi = @(x,y) a/4*y.^4 + b/4*x.^4;       % Stream function
U   = @(X) [ a*X(2).^3                  % Velocity vector (u; v)
            -b*X(1).^3 ];               % X(1) = x, X(2) = y
J   = @(X) %[ DEFINE JACOBIAN HERE ]    % Jacobian matrix

% Initial guess
X   = [1;0.2];                          % [x;y] coordinates of initial point

% Show stream function and initial guess
figure(1);
clf;
points = -1:0.01:1;
[xplot,yplot] = meshgrid(points,points);
contourf(xplot,yplot,psi(xplot,yplot)); 
hold on;
scatter(X(1),X(2),'red','filled');
    
% Options for iterative solvers
tol = 1e-5;
error = inf;
itmax = 1000;
theta = 0.1;
it = 0;


%% Fixed-point method
while error>tol && itmax>it
    
    Xold  = X;

        % [ IMPLEMENT THE FIXED POINT ALGORITHM HERE ]
    
    % Compute the error
    error = norm(X-Xold);
    it    = it+1;
    convergenceFP(it) = error;

    % Show progress
    fprintf('Fixed point: it=%d, error=%f \n',it,error);
    scatter(X(1),X(2),'red','filled');
    drawnow;

end
fprintf('Fixed point: Converged after %d iterations \n',it);


%% Newton method
error = inf;
it = 0;
X   = [1;0.2];                          % Initial condition

while error>tol && itmax>it
    
    Xold = X;

        % [ IMPLEMENT THE NEWTON ALGORITHM HERE ]
    
    % Compute the error
    error = norm( X - Xold );
    it = it+1;
    convergenceN(it) = error;
    
    % Show progress
    fprintf('Newton: it=%d, error=%f \n',it,error)
    scatter(X(1),X(2),'green','filled');
    drawnow
    
end
fprintf('Newton: Converged after %d iterations \n',it);

% Plot convergence
figure(2); clf;
plot(convergenceFP);
hold on;
plot(convergenceN);