% Semester : 2017 S
% Linear transport - home assignment.
%
% names :  NAME1 NAME2 NAME3
% group :  (1,2 or 3)
%
%  In this file will be solved numerically the convection equation.

clc       % clean the prompt.
clear all % clear the stored variables.
close all % close all the windows that could have been opened.


%-------------------------------------------------
% initialization of the variables
%-------------------------------------------------

% space variables
N = 101;
x0    = 0 ;
x_end = 1;
dx    = (x_end-x0)/(N-1);
x =  [x0 : dx : x_end]' ;


% creating time variables
t = 0;
t_end  = 10;
CFL = 1;

eps = dx/2;

%%% create a velocity function
%change this function to see what happens (the velocity should not change too fast in time)
%u_func =@(x,t) 1+x+0.1*t ;
u_func = @(x,t) ones(size(x));

% initial data                             
% change this values to see what happens
H =  exp(-(x/x_end-0.5).^2*20)  .* (x>0.01)   ;

max_H0 = max(H); % this is just to have a nice plot later on
 
 
% Dirichlet boundary condition
H_dirichlet = 0 ;
% snow accumulation rate
M = 0;                       
%M= 0.01 * ( 1 -x);          
it = 0;
while t < t_end
   %updating velocities 
   u = u_func(x,t);
   
   %setting dt depending on velocity fluctuations
   dt = transport_get_dt(CFL,u,dx);                             % this function has to be implemented
   
   H  = solve_transport_time_step(H,u,dx,dt,eps,M,H_dirichlet); % this function has to be implemented
   
   %advancing in time
   t=t+dt;
   it = it +1;
   figure(1)
  
   % just for plotting and displaying some data
   % every 10 iteration, one look at the results
   % if one writes mod(it,1) == 0 it will be at every iteration
   if mod(it,10) == 0 
   fprintf('t = %3.3f,\t dt = %2.3e,\t max(u) = %3.3f max(H) = %8.3e \n',t,dt,max(u),max(H))
   plot(x,H)
   axis([x0 x_end 0 max_H0])
   end
end
