clc
clear all
close all

% defining space variables
x_min = 0   ;
dx    = 0.001;
x_max = 1   ;
x = [x_min : dx : x_max]';
N = length(x);
% defining ODE coefficients
B  = x; 
C  = -(1+x)*pi^2.*cos(pi*x) - pi*sin(pi*x) -x.*cos(pi*x) ;

% mu has to be defined on a staggered grid so that accuracy is not lost
x_stag = ... %create the staggered grid
mu = 1+x_stag ;                                     

% velocity at dirichlet boundary condition
u_dir = 1;

% computing the velocities
U = get_velocity(mu,B,C,x,dx,u_dir);              % this function has to be implemented

% just plotting
figure(1)
plot(x,U,'b',x,cos(pi*x),'r');

% compute the norm of the error,
err = sum(sqrt((U-cos(pi*x)).^2))/N ;