clc
clear all
close all

% defining space variables
N     = 101  ; 
x_min = 0    ;
x_max = 1    ;
dx    = (x_max-x_min)/(N-1);
x = [x_min : dx : x_max]';


% defining ODE coefficients
p = 2 ; % power of the gradient norm in the diffusion term
mu = 1 ; % coef of the reaction term

q = 2 ; % power in the reaction term
B  = 1; % coef of the reaction term 

% source term
f  = -3*pi^4*cos(pi*x).*sin(pi*x).^2 - B * cos(pi*x).^3 ;

% velocity at dirichlet boundary condition
u_dir = 1;

% a guess that is not too far from the solution
U_guess = cos(pi*x).*(1+x) ;

% computing the velocities
U = NL_get_velocity_picard(U_guess,mu,B,f,p,q,x,dx,u_dir);
%U = NL_get_velocity_newton(U_guess,mu,B,f,p,q,x,dx,u_dir);
% just plotting
figure(1)
plot(x,U,'bx',x,cos(pi*x),'r');

% compute the norm of the error,
err = sum(sqrt((U-cos(pi*x)).^2))/N 