function  V_k = get_U_fixed_point(U_n,D,dx,dt,tol,dirichlet_value,theta)


V_k = U_n;

norm_ = 1 ;
it = 0;
it_max = 500 ;

convection_coef = dt/dx /2 ;
diffusion_coef  =D*dt/dx/dx;

while norm_ > tol && it_max >it

    % assume that we have dirichlet BC at x = 0
    V_i_minus_one = [dirichlet_value ;V_k(1:end-1)];
    % assume the we have neumann BC at x = 1  
    V_i_plus_one = [ V_k(2:end); V_k(end) ];

    % computes the new U_k (explicit scheme can be done without matrix)    
    convection =  -V_k.*(V_i_plus_one - V_i_minus_one)*convection_coef;
    convection(1) = convection(1)*2; % equivalent to uncentered scheme close to the Dirichlet BC.
    
    diffusion = diffusion_coef  * ( V_i_plus_one -2*V_k+ V_i_minus_one  ) ;
    
    U_k_new = U_n + diffusion + convection ;
    
    % enforcing the dirichlet BC.
    U_k_new(1) =dirichlet_value ;
    
    % update convergence criterion
    norm_ = norm(U_k_new-V_k)/norm(V_k);
    % relaxation
    V_k = theta * U_k_new+ (1-theta)*V_k;
% for understanding what happens/debugging    
%    plot(V_k)
%    pause
   it = it+1 ;
end

pprintf('after %d (fixed point) iteration, norm = %e \n',it,norm_ )


end









































































































































































% AUTHOR : Pierre-Emmanuel des Boscs
% Date   : June 16th 2017
% Code for exercise 7.

