clc 
clear all
close all
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  solve the 1D - Burger equation using a fixed point method.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% space variables
N = 1000;
x_min = 0;
x_max = 1;
dx = (x_max-x_min)/(N-1);
x = [x_min:dx:x_max]' ;

% time variables
t_end =100;
t     =0;

% one can play with this parameter to see how robust are both methods (newton > fixed point in term of stability)
% in the fixed point case, theta has to be diminished as dt increase.
dt = 0.001;
theta = 0.01;

% iteration number
it =0 ;

%Diffusion coefficient
D = 0.01 ;

% initial condition
U = (x<0.5).*ones(size(x));


dirichlet_value = 1;

while t<= t_end
    % plotting 
    if(mod(it,10)==0) % modify this line to change the plotting frequency
    figure(1)
    plot(x,U)
    axis([0 1 -0.5 1.5])
    title(['T at t=',num2str(t)])
    pause(1)
    end
    % 
    % fixed point method
    %
    % perform some fixed point iteration until convergence is reached.
    U = get_U_fixed_point(U,D,dx,dt,1e-07,dirichlet_value,theta) ;
    
    %
    % Newton method 
    %
    % perform newton algorithm to find the new U.
%    U = get_U_newton(U,D,dx,dt,1e-07,dirichlet_value);
    
    
    % update iteration variables
    t = t+dt;
    it = it+1;
    
end

