u = @(x) [x(2); -x(1)];     % Velocity field
x = [1; 0];                 % Initial position of fluid element
t = 0;                      % Starting time
tfin = 2*pi;                % Final time
dt = 0.5;                   % Time step size

pathx = x(1);               % x coordinates of the streamline
pathy = x(2);               % y coordinates of the streamline

% Time stepping loop
while t < tfin
   
    % Runge-Kutta

        % [ COMPUTE POSITION OF FLUID ELEMENT AT NEXT TIME STEP ]
    
    % Append current position of fluid element to the resolved pathline
    pathx = [pathx; x(1)];
    pathy = [pathy; x(2)];
    
    % Time at next time step
    t = t+dt;
    
    % Show path line
    plot(pathx,pathy);
    axis([-1.5 1.5 -1.5 1.5])
    title(['t =' num2str(t)]);
    drawnow;
    
end