% Discretization
x1   = 0;                                   % Left boundary
xN   = 1;                                   % Right boundary
dx   = 0.01;                                % Grid spacing
dt   = 0.01;                                % Time step size
N    = (xN-x1)/dx + 1;                      % Number of grid points
x    = (x1:dx:xN)';                         % Discretization grid
e    = ones(N,1);                           % Auxiliary vector for spdiags
A = spdiags([-e/2/dx e/2/dx],[-1 1],N,N);   % Discretization matrix (du/dx)
I  = speye(N);                              % Identity matrix

% Boundary conditions

    % [ IMPLEMENT PERIODIC BOUNDARY CONDITION IN THE DISCRETIZATION  ]
    % [ MATRIX A                                                     ] 

% Exact solution
u_ex = @(t) exp( -(x-sin(2*pi*t)/2/pi-0.5).^2 / 0.04 );

% Initial condition
u    = u_ex(0);                         % Solution at current time step
uEuler = u;                             % For implicit Euler
u_m1 = u_ex(-dt);                       % Solution at previous time step
n    = 0;                               % Current time step
t    = 0;                               % Current time

% Time stepping loop
tmax = 0.5;                             % Final time

while t < tmax

    % Implicit Euler scheme
    uEuler = (dt*cos(2*pi*(t+dt))*A+I) \ uEuler ;
    
    % Leap-frog scheme
    u_p1 = %[ COMPUTE THE SOLUTION AT NEXT TIME STEP HERE ]

    % Time corresponding to next time step
    n = n+1;                    
    t = n*dt;
    
    % Plot solution
    plot(x,u_p1,x,u_ex(t));
    ylim([0 1]);
    legend('numerical','exact');
    drawnow;
    
    % Keep previous time step in memory
    u_m1 = u;
    u = u_p1;
    
end