function V = Newton(U,tol_N,it_max,D_x1,D_y1,D_x2,D_y2,Id,D_H,D_Z,v_x,v_y,...
                    alpha,beta,dt,div,N)
% INPUTS
%   U:          Solution vector at known timestep n
%   tol_N:      Tolerance for convergence of Newton algorithm
%   it_max:     Maximum number of iterations
%   D_x1,D_y1:  Matrices of discrete first derivatives in x and y
%   D_x2,D_y2:  Matrices of discrete second derivatives in x and y
%   Id:         Identity matrix
%   D_H:        Diffusivity of humans
%   D_Z:        Diffusivity of zombies
%   v_x:        Migration velocity in x direction at all grid points
%   v_y:        Migration velocity in y direction at all grid points
%   alpha:      Reduction rate of humans at all grid points
%   beta:       Creation rate of zombies at all grid points
%   dt:         Time step size
%   div:        Divergence of migration velocity field
%   N:          Number of grid points
%
% OUTPUTS:
%   V:          Solution at next time-step
                

% Compute M2(U)
[M2] = DiscreteRHS(Id,D_x1,D_y1,D_x2,D_y2,D_H,D_Z,v_x,v_y,alpha,beta,...
                   dt,div,U,N);

    
% Initialize the algorithm
V = U;              % initial guess
delta_V = Inf;      % Rate of change of V (to enter the loop)
it = 0;             % Iteration counter

while it<it_max
    
    % Compute M1(V)
    [M1] = DiscreteLHS(Id,D_x1,D_y1,D_x2,D_y2,D_H,D_Z,v_x,v_y,alpha,beta,dt,...
                          div,V,N);


    % [ IMPLEMENT NEWTON-RAPHSON ALGORITHM HERE ]                 
                      
                      
    % Print progress
    if mod(it,1000)==0
        fprintf('it = %d, delta = %f \n',it,norm(delta_V));
    end
    
end

% Check negative numbers
if min(V)<0
    disp('Negative values! Decrease the time step!');
end

% Convergence message
if it<it_max
    fprintf('Converged after %d iterations \n',it);
else
    fprintf('Not converged! delta = %f \n',norm(delta_V));
end

end