function [Jac] = ComputeJac(Id,D_x1,D_y1,D_x2,D_y2,D_H,D_Z,v_x,v_y,...
                            alpha,beta,dt,div,V,N)
% INPUTS
%   Id:         Identity matrix
%   D_x1,D_y1:  Matrices of discrete first derivatives in x and y
%   D_x2,D_y2:  Matrices of discrete second derivatives in x and y
%   D_H:        Diffusivity of humans
%   D_Z:        Diffusivity of zombies
%   v_x:        Migration velocity in x direction at all grid points
%   v_y:        Migration velocity in y direction at all grid points
%   alpha:      Reduction rate of humans at all grid points
%   beta:       Creation rate of zombies at all grid points
%   dt:         Time step size
%   div:        Divergence of migration velocity field
%   V:          Estimated solution vector at unknown timestep n+1
%   N:          Number of grid points
%
% OUTPUTS
%   Jac:        Jacobian matrix of F(V)


% Decompose solution vector
H = V(1:N);
Z = V(N+1:2*N);
                       

    % [ COMPUTE JACOBIAN MATRIX HERE. IT SHOULD BE SPARSE! ]


end