% Computational grid
x1   = 0;                                   % Left boundary
xN   = 10;                                  % Right boundary
y1   = 0;                                   % Bottom boundary
yN   = 1;                                   % Top boundary
dx   = 0.05;                                % Grid spacing in x
dy   = 0.05;                                % Grid spacing in y
dt   = 0.1;                                 % Time step size
I    = (yN-y1)/dy + 1;                      % Number of grid points in y
J    = (xN-x1)/dx + 1;                      % Number of grid points in x
N    = I * J;                               % Total number of points
[x,y] = meshgrid((x1:dx:xN),(yN:-dy:y1)');  % Discretization grid

% Indicies of boundaries
left  = find(x(:)==x1);
right = find(x(:)==xN);
bottom= find(y(:)==y1);
top   = find(y(:)==yN);

% Velocity field
u = (y(:)-y(:).^2)*1 ;

% Diffusivity
kappa = 1e-3;

% Internal heating 
f = zeros(N,1);

% Initial condition
T = zeros(N,1);
T(bottom)=1;
T(top)=1;
t = 0;

% Discretization matrices
Id   = speye(N);                                % Identity matrix
e    = ones(N,1);                               % Auxiliary vector for spdiags
D_x1 = %[ Create matrix representing the discrete first derivative in x ]
D_x2 = %[ Create matrix representing the discrete second derivative in x ]
D_y2 = %[ Create matrix representing the discrete second derivative in y ]
A = -u.*D_x1 + kappa*(D_x2+D_y2); 


% Dirichlet
% [implement Dirichlet BCs here]


% Neumann
for node = right'
    % [implement Neumann BCs here]
end


% Time stepping loop
while 1
    T = %[compute the next time step with implicit Euler]
    contourf(x,y,reshape(T,I,J));
    colorbar;
    drawnow;
end