function [D_x1,D_y1,D_x2,D_y2] = FDMatrices(I,N,dx,dy,left,right,bottom,top)


%% Derivatives for interior nodes
e = ones(N,1);

% First derivatives
first_derivs = 'central2';
if strcmp(first_derivs,'central2')
    D_x1 = spdiags( [-1*e  0*e 1*e]/(2*dx) , [-I   0   I] , N , N );
    D_y1 = spdiags( [-1*e  0*e 1*e]/(2*dy) , [ 1   0  -1] , N , N );
elseif strcmp(first_derivs,'upwind1')
    D_x1 = spdiags( [-1*e  1*e 0*e]/(1*dx) , [-I   0   I] , N , N );
    D_y1 = spdiags( [-1*e  1*e 0*e]/(1*dy) , [ 1   0  -1] , N , N );
elseif strcmp(first_derivs,'upwind2')
    D_x1 = spdiags( [ 1*e -4*e 3*e]/(2*dx) , [-2*I -I   0] , N , N );
    D_y1 = spdiags( [ 1*e -4*e 3*e]/(2*dy) , [ 0   -1  -2] , N , N );
end

% Second derivatives - 2nd order central differences
D_x2 = spdiags( [ 1*e -2*e 1*e]/ dx^2  , [-I   0   I] , N , N );
D_y2 = spdiags( [ 1*e -2*e 1*e]/ dy^2  , [ 1   0  -1] , N , N );


%% Derivatives for boundary nodes

% Discretization matrices for boundaries (ghost point method)
e = ones(N,1);
if strcmp(first_derivs,'central2')
    D_x2l = spdiags( [-2*e  2*e]/dx^2 , [ 0  I ] , N , N );
    D_x2r = spdiags( [ 2*e -2*e]/dx^2 , [-I  0 ] , N , N );
    D_y2b = spdiags( [-2*e  2*e]/dy^2 , [ 0 -1 ] , N , N );
    D_y2t = spdiags( [ 2*e -2*e]/dy^2 , [ 1  0 ] , N , N );
elseif strcmp(first_derivs,'upwind1')
    D_x2l = spdiags( [-1*e  1*e]/dx^2 , [ 0  I ] , N , N );
    D_x2r = spdiags( [ 1*e -1*e]/dx^2 , [-I  0 ] , N , N );
    D_y2b = spdiags( [-1*e  1*e]/dy^2 , [ 0 -1 ] , N , N );
    D_y2t = spdiags( [ 1*e -1*e]/dy^2 , [ 1  0 ] , N , N );    
end

% Replace global discretization matrices on boundaries
D_x2(left        ,:) = D_x2l(left  ,:);
D_x2(right       ,:) = D_x2r(right ,:);
D_y2(bottom      ,:) = D_y2b(bottom,:);
D_y2(top         ,:) = D_y2t(top   ,:);

% First derivative on boundaries is defined by boundary conditions
if strcmp(first_derivs,'upwind1')
    D_x1(left  ,:) = 0;
    D_y1(bottom,:) = 0;
elseif strcmp(first_derivs,'central2')
    D_x1([left;right],:)=0;
    D_y1([bottom;top],:) = 0;
end


end