function [M1] = DiscreteLHS(Id,D_x1,D_y1,D_x2,D_y2,D_H,D_Z,v_x,v_y,...
                            alpha,beta,dt,div,V,N)

% Decompose solution vector
H = V(1:N);
Z = V(N+1:2*N);
                        
% Compute A1, A2
A_HH = Id - dt/2 * ( D_H*(D_x2+D_y2)                   ...
                       - v_x(:).*D_x1 - v_y(:).*D_y1 ...
                       - div(:).*Id );
                   
A_HZ = dt/2 * alpha(:).*H(:).*Id ;

A_ZZ = Id - dt/2 * ( D_Z*(D_x2+D_y2) );

A_ZH = - dt/2 * beta(:).*Z.*Id ;
                   
                   
% Compose M1   
M1 = [  A_HH  A_HZ
        A_ZH  A_ZZ  ];
    
end