function [Robin,Newton] = BoundaryConditions(Id,dx,dy,dt,D_H,D_Z,v_x,v_y,left,right,bottom,top,N)

first_derivs = 'upwind1';

% homogeneous Robin BC ghost point
Robin = sparse(N,N);

if strcmp(first_derivs,'upwind1')
    Robin(right ,:) = dt*Id(right ,:).*(D_H/dx^2 +v_x(right )/dx);...
                                          %+ v_x(right  ).^2/D_H);
    Robin(left  ,:) = dt*Id(left  ,:).*(D_H/dx^2 -v_x(left  )/dx...
                                          - v_x(left  ).^2/D_H);
    Robin(top   ,:) = dt*Id(top   ,:).*(D_H/dy^2 +v_y(top   )/dy);...
                                          %+ v_y(top   ).^2/D_H);  
    Robin(bottom,:) = dt*Id(bottom,:).*(D_H/dy^2 -v_y(bottom)/dy...
                                          - v_y(bottom).^2/D_H);   
end

% homogeneous Neumann BC ghost point
Newton = sparse(N,N);
if strcmp(first_derivs,'upwind1')
    Newton(right ,:) = dt*Id(right ,:) * D_Z / dx^2;
    Newton(left  ,:) = dt*Id(left  ,:) * D_Z / dx^2;
    Newton(top   ,:) = dt*Id(top   ,:) * D_Z / dy^2;
    Newton(bottom,:) = dt*Id(bottom,:) * D_Z / dy^2;
end

% Accumulation conditions

end