function [] = ShowDistribution(U,Hmax,Zmax,t,I,J,N,x,y,L_x,L_y)

H = reshape( U(1  :  N), I,J);
Z = reshape( U(N+1:2*N), I,J);

subplot(1,2,1); 
    surf(x,y,H); 
    zlim([0 Hmax]);
    xlim([0 L_x]);
    ylim([0 L_y]);
    xlabel('x');
    ylabel('y');
    zlabel('Concentration of humans (1/km^2)');

subplot(1,2,2); 
    surf(x,y,Z); 
    zlim([0 Zmax]);
    xlim([0 L_x])
    ylim([0 L_y])
    xlabel('x');
    ylabel('y');
    zlabel('Concentration of zombies (1/km^2)');

title(sprintf('t = %f days',t/24)); drawnow;

end