function [M2] = DiscreteRHS(Id,D_x1,D_y1,D_x2,D_y2,D_H,D_Z,v_x,v_y,...
                            alpha,beta,dt,div,U,N)

% Decompose solution vector
H = U(1:N);
Z = U(N+1:2*N);
                        
% Compute B matrices
B_HH = Id + dt/2 * ( D_H*(D_x2+D_y2)           ...
                 - v_x(:).*D_x1 - v_y(:).*D_y1 ...
                 - div(:).*Id                     );  
             
B_HZ = - dt/2 * alpha(:) .* H .* Id ;
             
B_ZZ = Id + dt/2 * ( D_Z*(D_x2+D_y2)  );

B_ZH = dt/2 * beta(:) .* Z .* Id ;           
  

% Compose the M2 matrix             
M2 = [  B_HH   B_HZ
        B_ZH   B_ZZ  ]; 

    
end