function[h_new,M_adv] = solve_continuity(h,u,dx,dt,h_left)

% Build the vector of right hand sides "B" (source terms)
%   We are solving a homogeneous PDE, therefore B = 0 for interior nodes
N = length(h);
B = zeros(N,1);


% Build discretization matrix
M_adv = continuity_build_matrix(u, dx, dt);


% Apply boundary conditions
[M_adv, B] = continuity_apply_bc(M_adv, B, h_left);


% Solve the linear problem
h_new = M_adv * h + B ;


end