%% Code hygiena
clear;                                  % clears memory
close all;                              % closes all open figures

%% Settings

% Parameters
N = 1001;                               % number of computational points
x_min = 0;                              % position of left boundary
x_max = 100;                            % position of right boundary
dx = (x_max-x_min)/(N-1);               % grid spacing
dt = 0.5 * dx / 1;                      % size of time step
g = 9.81;                               % gravitational acceleration


% Spatial discretization
x = [x_min : dx : x_max ]';             % main grid
x_ = [x_min+dx/2 : dx : x_max-dx/2]';   % staggered grid


% Definition of test functions
b = 100 - 0.1*x;                        % channel bed profile
h = 120 - 0.1*x;                        % water depth profile
w = 1;                                  % channel width
n = 0.01;                               % Manning's friction coefficient
U_exact = 10 + 0.01* x_;                % Required velocity at step (n+1)
u = (10+0.01*x_).*(1+0.01*dt) ...               % Initial velocity 
    + dt*g* (-0.2 + n.^2 * (10+0.01*x_).^2 ...  % at step (n)
    .* ((1+240-0.2*x_)./(120-0.1*x_)).^(4/3));



%% Computation
      
    % Visualization of initial velocity
    figure(1);
    plot(x_,U_exact,x_,u); legend('final','initial');
    tic();
    
    % Calculation of step (n+1)
    [u] = solve_momentum_transport(u,h,w,n,dx,dt,b);
    time_to_solve =toc 
    pause(1);
      
    % Visualization of results
    figure(1);
    plot(x_,U_exact,x_,u); legend('exact','numerical');
   

%% Calculate the error using the function "norm"

% error = 
