function  V_k = get_U_fixed_point(U_n,D,dx,dt,tol,dirichlet_value,theta)


V_k = U_n;
error = Inf ;
it = 0;
it_max = 500 ;

convection_coef = dt/dx /2 ;
diffusion_coef  =D*dt/dx/dx;

while error > tol && it_max >it

    % assume that we have dirichlet BC at x = 0
    V_i_minus_one = [dirichlet_value ;V_k(1:end-1)];

    % assume the we have neumann BC at x = 1  
    V_i_plus_one = [ V_k(2:end); V_k(end-1) ];

    % computes the new U_k (explicit scheme can be done without matrix)    
    convection =  -V_k.*(V_i_plus_one - V_i_minus_one)*convection_coef;
    
    diffusion = diffusion_coef  * ( V_i_plus_one -2*V_k+ V_i_minus_one  ) ;
    
    V_k_new = U_n + convection + diffusion ;
        
    % update convergence criterion
    error = norm(V_k_new-V_k)/norm(V_k);
    
    % relaxation
    V_k = theta * V_k_new + (1-theta)*V_k;
    
    % for understanding what happens/debugging    
%    plot(V_k)
%    pause

    it = it+1 ;

end

pprintf('after %d (fixed point) iteration, norm = %e \n',it,error )


end









































































































































































% AUTHOR : Pierre-Emmanuel des Boscs
% Date   : June 16th 2017
% Code for exercise 7.

