clear variables

a   = 1 ;
b   = 1 ;
flow = '3rd';
if strcmp(flow,'solid_body_rotation')
    psi = @(x,y) a/2*y.^2 + b/2*x.^2;       % Stream function
    A   = @(X) [  0  a
                 -b  0  ];
    U   = @(X) A*X;                         % Velocity field
elseif strcmp(flow,'Taylor_Green')
    psi = @(x,y) -cos(x).*cos(y);
    U   = @(X) [ cos(X(1)).*sin(X(2))
                -sin(X(1)).*cos(X(2)) ];
    A   = @(X)[ -sin(X(1))*sin(X(2))   cos(X(1))*cos(X(2))
                -cos(X(1))*cos(X(2))   sin(X(1))*sin(X(2))  ];
elseif strcmp(flow,'3rd')
    psi = @(x,y) a/4*y.^4 + b/4*x.^4;       % Stream function
    U   = @(X) [ a*X(2).^3 
                -b*X(1).^3 ];                  % Velocity field    
    A   = @(X) [  0             3*a*X(2).^2
                 -3*b*X(1).^2   0            ];
end

X   = [1;0.2];                          % Initial condition

figure(1);
clf;
picture = '2D';
if strcmp(picture,'2D')
    points = -1:0.01:1;
    [xplot,yplot] = meshgrid(points,points);
    contourf(xplot,yplot,psi(xplot,yplot)); 
    hold on;
    scatter(X(1),X(2),'red','filled');
elseif strcmp(picture,'3D')
    fsurf(psi,[-1 1 -1 1]);
    hold on;
    scatter3(X(1),X(2),psi(X(1),X(2)),'red','filled');
end
    
% Options for iterative solver
tol = 1e-5;
error = inf;
itmax = 1000;
theta = 0.5;
it = 0;

% Fixed-point method
while error>tol && itmax>it
    
    Xnew  = U(X);
    Xold  = X;
    X     = theta*Xnew + (1-theta)*X;
    error = norm(X-Xold);
    it    = it+1;
    convergenceFP(it) = error;


        fprintf('Fixed point: it=%d, error=%f \n',it,error)
        if strcmp(picture,'2D'), scatter(X(1),X(2),'red','filled');
        elseif strcmp(picture,'3D'), scatter3(X(1),X(2),psi(X(1),X(2)),'red','filled'); end
        drawnow

    
end
fprintf('Fixed point: Converged after %d iterations \n',it);

% Newton method
error = inf;
it = 0;
X   = [1;0.2];                          % Initial condition

while error>tol && itmax>it
    
    deltaX = - A(X)\U(X) ;
    X = X + deltaX;
    error = norm(deltaX);
    it = it+1;
    convergenceN(it) = error;
    
        fprintf('Newton: it=%d, error=%f \n',it,error)
        if strcmp(picture,'2D'), scatter(X(1),X(2),'green','filled');
        elseif strcmp(picture,'3D'), scatter3(X(1),X(2),psi(X(1),X(2)),'green','filled'); end
        drawnow
    
end
fprintf('Newton: Converged after %d iterations \n',it);
scatter(X(1),X(2),'green','filled');

% Plot convergence
figure(2); clf;
plot(convergenceFP);
hold on;
plot(convergenceN);