clc 
clear all
close all
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  solve the 1D - Burger equation using a fixed point/Newton method.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% space variables
N = 1000;
x_min = 0;
x_max = 1;
dx = (x_max-x_min)/(N-1);
x = [x_min:dx:x_max]' ;

% time variables
t_end =100;
t     =0;
dt = 0.001;

% iteration number
it =0 ;

%Diffusion coefficient
D = 0.01 ;

% initial condition
U = exp(-(x-0.5).^2/0.02) ;
dirichlet_value = 0;

while t<= t_end
    
    % plotting stuff
    if(mod(it,10)==0)
    figure(1)
    plot(x,U)
    axis([0 1 -0.5 1.5])
    title(['T at t=',num2str(t)])
    drawnow;
    end
    
    % perform some fixed point iteration until convergence is reached.
    U = get_U_fixed_point(U,D,dx,dt,1e-07,dirichlet_value,0.01) ;
    % perform newton algorithm to find the new U.
%     U = get_U_newton(U,D,dx,dt,1e-07,dirichlet_value);
    
    % update iteration variables
    t = t+dt;
    it = it+1;

end

