a   = 2 ;
b   = 1 ;
psi = @(x,y) a/2*y.^2 + b/2*x.^2;           % Stream function
u   = @(x,y) [a*y; -b*x];                   % Velocity field
x   = 1;                                    % Initial condition
y   = 0;
X   = [x;y];
t   = 0;                                    % Starting time  
tfin = 2*pi;                                % Final time
dt = 0.5;                                   % Time step size

trajectory.x = x;               % x coordinates of the streamline
trajectory.y = y;               % y coordinates of the streamline

figure(1);
clf;

% Runge-Kutta 2
while t < tfin
   
    k1 = dt*u(x,y);
    k2 = dt*u(x+k1(1)/2, y+k1(2)/2);
    x  = x + k2(1);  
    y  = y + k2(2);
    
    trajectory.x = [trajectory.x; x];
    trajectory.y = [trajectory.y; y];
    
    t = t+dt;
    
    plot(trajectory.x,trajectory.y);
    axis([-1.5 1.5 -1.5 1.5])
    title(['t =' num2str(t)]);
    drawnow;
    
end

% Adams-Moulton 2
A = [ 0  a
     -b  0 ];
I = [ 1  0
      0  1 ];
trajAM.x=[X(1);X(1)];
trajAM.y=[X(2);X(2)];
t=0;
hold on;

while t<tfin
    
     X = (I-0.5*dt*A)\(I+0.5*dt*A)*X ;
     trajAM.x = [trajAM.x ; X(1)];
     trajAM.y = [trajAM.y ; X(2)];
     
     t=t+dt;
     
    plot(trajAM.x(end-1:end),trajAM.y(end-1:end),'red');
    axis([-1.5 1.5 -1.5 1.5])
    title(['t =' num2str(t)]);
    drawnow;
    
end
