clc 
clear all
close all
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  solve the 1D - Burger equation
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



N = 1000;

x_min = 0;
x_max = 1;

dx = (x_max-x_min)/(N-1);
x = [x_min:dx:x_max]' ;

t_end =100;
t     =0;

dt = 0.001;

it =0 ;
D = 0.01 ;


U = exp(-(x-0.5).^2/0.02) ;
dirichlet_value = 0;


 mat    = build_matrix_semi_implicit(D,dx,dt,N);
[mat,U] =  apply_BC(mat,U) ;

while t<= t_end
 

    if(mod(it,1)==0)
        figure(1)
        plot(x,U)
        axis([0 1 -1 2])
        title(['T at t=',num2str(t)])
        drawnow;
    end
    
    RHS = build_RHS(U,dt,dx,dirichlet_value) ;
    RHS(1) = dirichlet_value;
    U = mat\RHS ;
    
    t = t+dt;
    it = it+1;
end



























