% Parameters
D  = 1e-1;
dt = 1e-2;
u  = 1;

% Grid
x1   = 0;                                   % Left boundary
xN   = 1;                                   % Right boundary
dx   = 0.01;                                % Grid spacing
N    = (xN-x1)/dx + 1;                      % Number of grid points
x    = (x1:dx:xN)';                         % Discretization grid

% Initial condition
T = 1-x+exp(-(x-0.5).^2/0.02);
TEuler = T;

% Semi-discretization in space
e    = ones(N,1);                           % Auxiliary vector for spdiags
D_x1 = spdiags([-e e]/2/dx,[-1 1],N,N);
D_x2 = spdiags([e -2*e e]/dx^2,[-1 0 1],N,N);
A    = -u*D_x1+D*D_x2;   % Discretization matrix (du/dx)
Id   = speye(N);                              % Identity matrix

% Boundary conditions
A(1,1) = A(1,1) - A(2,1)*2*dx*u/D;
A(1,2) = A(1,2) + A(2,1)*1;
A(N,N-1) = A(N,N-1) + A(N-1,N)*1;
A(N,N)   = A(N,N) + A(N-1,N)*2*dx*u/D;

% Time-stepping loop
while 1
    T = (Id - 0.5*dt*A) \ (Id + 0.5*dt*A)*T;
    TEuler = (Id - dt*A)\TEuler;
    plot(x,T,x,TEuler);
    ylim([0 2]);
    drawnow;
    pause(0.1);
end