% Discretization
x1 = 0;                                     % Left boundary
xN = 1;                                     % Right boundary
dx = 0.01;                                  % Grid spacing
dt = 0.01;                                  % Time step size
N  = (xN-x1)/dx + 1;                        % Number of grid points
x  = (x1:dx:xN)';                           % Discretization grid
e  = ones(N,1);                             % Auxiliary vector for spdiags
A  = spdiags([-e/2/dx e/2/dx],[-1 1],N,N);  % Discretization matrix (du/dx)
I  = speye(N);                              % Identity matrix

% Boundary conditions
A(1,N) = -0.5/dx;
A(N,1) =  0.5/dx;

% Exact solution
u_ex = @(t) exp( -(x-sin(2*pi*t)/2/pi-0.5).^2 / 0.04 );

% Initial condition
u       = u_ex(0);
uEuler  = u;
n       = 0;                % Number of time step
t       = 0;

% Time stepping loop
tmax = 0.5;                 % Maximum number of time steps

while t < tmax

    % Implicit Euler
    uEuler = (dt*cos(2*pi*(t+dt))*A+I) \ uEuler ;
    
    % Predictor-Corrector
    up = u - dt*cos(2*pi*t)*A*u ;
    u  = u - 1/2*dt*A*(cos(2*pi*t)*u + cos(2*pi*(t+dt))*up);

    % Time at next time step
    n = n+1;
    t = n*dt;
    
    % Show solution
    plot(x,u,x,u_ex(t),x,uEuler);
    ylim([0 1]);
    legend('numerical','exact','Implicit Euler');
    drawnow;
    
end