u = @(x) [x(2); -x(1)];     % Velocity field
x = [1; 0];                 % Initial condition
t = 0;                      % Starting time
tfin = 2*pi;                % Final time
dt = 0.05;                   % Time step size

pathx = x(1);               % x coordinates of the streamline
pathy = x(2);               % y coordinates of the streamline

% Time stepping loop
while t < tfin
   
    k1 = dt*u(x);
    k2 = dt*u(x+k1/2);
    x  = x + k2;    
    
    pathx = [pathx; x(1)];
    pathy = [pathy; x(2)];
    
    t = t+dt;
    
    plot(pathx,pathy);
    axis([-1.5 1.5 -1.5 1.5])
    title(['t =' num2str(t)]);
    drawnow;
    
end